/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.jsieve.BaseSieveContext;
import org.apache.jsieve.CommandManager;
import org.apache.jsieve.ComparatorManager;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.SieveParserVisitorImpl;
import org.apache.jsieve.SieveValidationVisitor;
import org.apache.jsieve.TestManager;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.StopException;
import org.apache.jsieve.mail.ActionKeep;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.generated.Node;
import org.apache.jsieve.parser.generated.ParseException;
import org.apache.jsieve.parser.generated.SieveParser;
import org.apache.jsieve.parser.generated.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SieveFactory {
    private final CommandManager commandManager;
    private final ComparatorManager comparatorManager;
    private final TestManager testManager;
    private final Log log;

    public SieveFactory(CommandManager commandManager, ComparatorManager comparatorManager, TestManager testManager, Log log) {
        this.commandManager = commandManager;
        this.comparatorManager = comparatorManager;
        this.testManager = testManager;
        this.log = log;
    }

    public Node parse(InputStream inputStream) throws ParseException {
        try {
            SimpleNode node = new SieveParser(inputStream, "UTF-8").start();
            SieveValidationVisitor visitor = new SieveValidationVisitor(this.commandManager, this.testManager, this.comparatorManager);
            node.jjtAccept(visitor, null);
            return node;
        }
        catch (ParseException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Parse failed. Reason: " + ex.getMessage()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parse failed.", (Throwable)ex);
            }
            throw ex;
        }
        catch (SieveException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Parse failed. Reason: " + ex.getMessage()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parse failed.", (Throwable)ex);
            }
            throw new ParseException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(MailAdapter mail, Node startNode) throws SieveException {
        BaseSieveContext context = new BaseSieveContext(this.commandManager, this.comparatorManager, this.testManager, this.log);
        try {
            mail.setContext(context);
            SieveParserVisitorImpl visitor = new SieveParserVisitorImpl(context);
            try {
                startNode.jjtAccept(visitor, mail);
            }
            catch (StopException ex) {
            }
            catch (SieveException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Evaluation failed. Reason: " + ex.getMessage()));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Evaluation failed.", (Throwable)ex);
                }
                throw ex;
            }
            if (((SieveContext)context).getCommandStateManager().isImplicitKeep()) {
                mail.addAction(new ActionKeep());
            }
            try {
                mail.executeActions();
            }
            catch (SieveException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Evaluation failed. Reason: " + ex.getMessage()));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Evaluation failed.", (Throwable)ex);
                }
                throw ex;
            }
        }
        finally {
            mail.setContext(null);
        }
    }

    public void interpret(MailAdapter mail, InputStream inputStream) throws ParseException, SieveException {
        this.evaluate(mail, this.parse(inputStream));
    }

    public List<String> getExtensions() {
        List<String> commands = this.commandManager.getExtensions();
        List<String> comparators = this.comparatorManager.getExtensions();
        List<String> tests = this.testManager.getExtensions();
        ArrayList<String> extensions = new ArrayList<String>(commands.size() + comparators.size() + tests.size());
        extensions.addAll(commands);
        extensions.addAll(comparators);
        extensions.addAll(tests);
        return extensions;
    }
}

