/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests;

import org.apache.jsieve.SieveContext;
import org.apache.jsieve.comparators.ComparatorUtils;
import org.apache.jsieve.exception.InternetAddressException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.tests.AbstractComparatorTest;

public class Address
extends AbstractComparatorTest {
    protected boolean match(MailAdapter mail, String addressPart, String comparator, String matchType, String headerName, String key, SieveContext context) throws SieveException {
        MailAdapter.Address[] addresses = this.getMatchingValues(mail, headerName);
        int length = addresses.length;
        int i = 0;
        boolean isMatched = false;
        while (!isMatched && i < length) {
            isMatched = this.match(addressPart, comparator, matchType, addresses[i++], key, context);
        }
        return isMatched;
    }

    private MailAdapter.Address[] getMatchingValues(MailAdapter mail, String valueName) throws SieveMailException, InternetAddressException {
        return mail.parseAddresses(valueName);
    }

    protected boolean match(String addressPart, String comparator, String matchType, MailAdapter.Address address, String key, SieveContext context) throws SieveException {
        String localPart = address.getLocalPart();
        String domain = address.getDomain();
        String matchAddress = addressPart.equals(":all") ? localPart + "@" + domain : (addressPart.equals(":localpart") ? localPart : domain.toLowerCase());
        String matchKey = null;
        matchKey = addressPart.equals(":domain") ? key.toLowerCase() : key;
        return ComparatorUtils.match(comparator, matchType, matchAddress, matchKey, context);
    }
}

