/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.jpa.JPAUsersRepository;
import org.apache.james.user.jpa.model.JPAUser;
import org.apache.james.user.lib.MockUsersRepositoryTest;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class JpaUsersRepositoryTest
extends MockUsersRepositoryTest {
    private HashMap<String, String> properties;
    private OpenJPAEntityManagerFactory factory;

    protected void setUp() throws Exception {
        this.properties = new HashMap();
        this.properties.put("openjpa.ConnectionDriverName", "org.h2.Driver");
        this.properties.put("openjpa.ConnectionURL", "jdbc:h2:target/users/db");
        this.properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        this.properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        this.properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        this.properties.put("openjpa.MetaDataFactory", "jpa(Types=" + JPAUser.class.getName() + ")");
        super.setUp();
        this.deleteAll();
    }

    protected void tearDown() throws Exception {
        this.deleteAll();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAll() {
        OpenJPAEntityManager manager = this.factory.createEntityManager();
        OpenJPAEntityTransaction transaction = manager.getTransaction();
        try {
            transaction.begin();
            manager.createQuery("DELETE FROM JamesUser user").executeUpdate();
            transaction.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            manager.close();
        }
    }

    protected UsersRepository getUsersRepository() throws Exception {
        this.factory = OpenJPAPersistence.getEntityManagerFactory(this.properties);
        JPAUsersRepository repos = new JPAUsersRepository();
        repos.setLog((Log)new SimpleLog("JPA"));
        repos.setEntityManagerFactory((EntityManagerFactory)this.factory);
        return repos;
    }
}

