/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.user.api.User;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.jpa.model.JPAUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAUsersRepository
implements UsersRepository,
Configurable,
LogEnabled {
    private EntityManagerFactory entityManagerFactory;
    private String algo;
    private Log logger;

    @PersistenceUnit
    public final void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public boolean addUser(User user) {
        throw new UnsupportedOperationException();
    }

    public void addUser(String name, Object attributes) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUser(String username, String password) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPAUser user = new JPAUser(username, password, this.algo);
            entityManager.persist((Object)user);
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (PersistenceException e) {
            this.logger.debug((Object)"Failed to save user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByName(String name) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            JPAUser jPAUser = (JPAUser)entityManager.createNamedQuery("findUserByName").setParameter("name", (Object)name).getSingleResult();
            return jPAUser;
        }
        catch (PersistenceException e) {
            this.logger.debug((Object)"Failed to find user", (Throwable)e);
            User user = null;
            return user;
        }
        finally {
            entityManager.close();
        }
    }

    public User getUserByNameCaseInsensitive(String name) {
        throw new UnsupportedOperationException();
    }

    public String getRealName(String name) {
        User u = this.getUserByName(name);
        if (u != null) {
            u.getUserName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUser(User user) {
        block7: {
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            EntityTransaction transaction = entityManager.getTransaction();
            try {
                if (this.contains(user.getUserName())) {
                    transaction.begin();
                    entityManager.merge((Object)user);
                    transaction.commit();
                    break block7;
                }
                this.logger.debug((Object)"User not found");
                boolean bl = false;
                return bl;
            }
            catch (PersistenceException e) {
                this.logger.debug((Object)"Failed to update user", (Throwable)e);
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                boolean bl = false;
                return bl;
            }
            finally {
                entityManager.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String name) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            entityManager.createNamedQuery("deleteUserByName").setParameter("name", (Object)name).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.logger.debug((Object)"Failed to remove user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            boolean bl = (Long)entityManager.createNamedQuery("containsUser").setParameter("name", (Object)name).getSingleResult() > 0L;
            return bl;
        }
        catch (PersistenceException e) {
            this.logger.debug((Object)"Failed to find user", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            entityManager.close();
        }
    }

    public boolean containsCaseInsensitive(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean test(String name, String password) {
        User user = this.getUserByName(name);
        boolean result = user == null ? false : user.verifyPassword(password);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countUsers() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            int n = ((Long)entityManager.createNamedQuery("countUsers").getSingleResult()).intValue();
            return n;
        }
        catch (PersistenceException e) {
            this.logger.debug((Object)"Failed to find user", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> list() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Iterator<String> iterator = Collections.unmodifiableList(entityManager.createNamedQuery("listUserNames").getResultList()).iterator();
            return iterator;
        }
        catch (PersistenceException e) {
            this.logger.debug((Object)"Failed to find user", (Throwable)e);
            Iterator<String> iterator = new ArrayList().iterator();
            return iterator;
        }
        finally {
            entityManager.close();
        }
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.algo = config.getString("algorithm", "MD5");
    }

    public void setLog(Log log) {
        this.logger = log;
    }
}

