/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vut.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.vut.jpa.JPAVirtualUserTable;
import org.apache.james.vut.jpa.model.JPAVirtualUser;
import org.apache.james.vut.lib.AbstractVirtualUserTable;
import org.apache.james.vut.lib.AbstractVirtualUserTableTest;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class JPAVirtualUserTableTest
extends AbstractVirtualUserTableTest {
    private OpenJPAEntityManagerFactory factory;
    private HashMap<String, String> properties;

    protected void setUp() throws Exception {
        this.properties = new HashMap();
        this.properties.put("openjpa.ConnectionDriverName", EmbeddedDriver.class.getName());
        this.properties.put("openjpa.ConnectionURL", "jdbc:derby:memory:JPAVirtualUserTableTestDB;create=true");
        this.properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        this.properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        this.properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        this.properties.put("openjpa.MetaDataFactory", "jpa(Types=" + JPAVirtualUser.class.getName() + ")");
        this.factory = OpenJPAPersistence.getEntityManagerFactory(this.properties);
        super.setUp();
    }

    protected AbstractVirtualUserTable getVirtualUserTable() throws Exception {
        JPAVirtualUserTable virtualUserTable = new JPAVirtualUserTable();
        virtualUserTable.setLog((Log)new SimpleLog("MockLog"));
        virtualUserTable.setEntityManagerFactory((EntityManagerFactory)this.factory);
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        virtualUserTable.configure((HierarchicalConfiguration)defaultConfiguration);
        return virtualUserTable;
    }

    protected boolean addMapping(String user, String domain, String mapping, int type) {
        if (type == 1) {
            return this.virtualUserTable.addErrorMapping(user, domain, mapping);
        }
        if (type == 0) {
            return this.virtualUserTable.addRegexMapping(user, domain, mapping);
        }
        if (type == 2) {
            return this.virtualUserTable.addAddressMapping(user, domain, mapping);
        }
        if (type == 3) {
            return this.virtualUserTable.addAliasDomainMapping(domain, mapping);
        }
        return false;
    }

    protected boolean removeMapping(String user, String domain, String mapping, int type) {
        if (type == 1) {
            return this.virtualUserTable.removeErrorMapping(user, domain, mapping);
        }
        if (type == 0) {
            return this.virtualUserTable.removeRegexMapping(user, domain, mapping);
        }
        if (type == 2) {
            return this.virtualUserTable.removeAddressMapping(user, domain, mapping);
        }
        if (type == 3) {
            return this.virtualUserTable.removeAliasDomainMapping(domain, mapping);
        }
        return false;
    }
}

