/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa.model;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Version;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.james.user.api.User;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

@Entity(name="JamesUser")
@NamedQueries(value={@NamedQuery(name="findUserByName", query="SELECT user FROM JamesUser user WHERE user.name=:name"), @NamedQuery(name="deleteUserByName", query="DELETE FROM JamesUser user WHERE user.name=:name"), @NamedQuery(name="containsUser", query="SELECT COUNT(user) FROM JamesUser user WHERE user.name=:name"), @NamedQuery(name="countUsers", query="SELECT COUNT(user) FROM JamesUser user"), @NamedQuery(name="listUserNames", query="SELECT user.name FROM JamesUser user")})
public class JPAUser
implements User,
PersistenceCapable {
    @Version
    private int version;
    @Id
    private String name;
    @Basic
    private String password;
    @Basic
    private String alg;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$james$user$jpa$model$JPAUser;
    private transient Object pcDetachedState;

    private static String hashPassword(String username, String password, String alg) {
        String newPass = alg == null || alg.equals("MD5") ? DigestUtils.md5Hex((String)password) : (alg.equals("NONE") ? "password" : (alg.equals("SHA-256") ? DigestUtils.sha256Hex((String)password) : (alg.equals("SHA-512") ? DigestUtils.sha512Hex((String)password) : DigestUtils.shaHex((String)password))));
        return newPass;
    }

    protected JPAUser() {
    }

    public JPAUser(String userName, String password, String alg) {
        this.name = userName;
        this.alg = alg;
        this.password = JPAUser.hashPassword(userName, password, alg);
    }

    public String getUserName() {
        return JPAUser.pcGetname(this);
    }

    public boolean setPassword(String newPass) {
        boolean result;
        if (newPass == null) {
            result = false;
        } else {
            JPAUser.pcSetpassword(this, JPAUser.hashPassword(JPAUser.pcGetname(this), newPass, JPAUser.pcGetalg(this)));
            result = true;
        }
        return result;
    }

    public boolean verifyPassword(String pass) {
        boolean result = pass == null ? JPAUser.pcGetpassword(this) == null : (JPAUser.pcGetpassword(this) == null ? false : JPAUser.pcGetpassword(this).equals(JPAUser.hashPassword(JPAUser.pcGetname(this), pass, JPAUser.pcGetalg(this))));
        return result;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (JPAUser.pcGetname(this) == null ? 0 : JPAUser.pcGetname(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPAUser other = (JPAUser)obj;
        return !(JPAUser.pcGetname(this) == null ? JPAUser.pcGetname(other) != null : !JPAUser.pcGetname(this).equals(JPAUser.pcGetname(other)));
    }

    public String toString() {
        return "[User " + JPAUser.pcGetname(this) + "]";
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"alg", "name", "password", "version"};
        Class[] classArray = new Class[4];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAUser.class$("java.lang.String"));
        classArray[3] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 21};
        Class clazz2 = class$Lorg$apache$james$user$jpa$model$JPAUser != null ? class$Lorg$apache$james$user$jpa$model$JPAUser : (class$Lorg$apache$james$user$jpa$model$JPAUser = JPAUser.class$("org.apache.james.user.jpa.model.JPAUser"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JamesUser", (PersistenceCapable)new JPAUser());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.alg = null;
        this.name = null;
        this.password = null;
        this.version = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        jPAUser.pcCopyKeyFieldsFromObjectId(object);
        return jPAUser;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        return jPAUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 4;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.alg = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.version = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.alg);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 3: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAUser jPAUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.alg = jPAUser.alg;
                return;
            }
            case 1: {
                this.name = jPAUser.name;
                return;
            }
            case 2: {
                this.password = jPAUser.password;
                return;
            }
            case 3: {
                this.version = jPAUser.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAUser jPAUser = (JPAUser)object;
        if (jPAUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAUser, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return new Integer(this.version);
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(1 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.name = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$james$user$jpa$model$JPAUser != null ? class$Lorg$apache$james$user$jpa$model$JPAUser : (class$Lorg$apache$james$user$jpa$model$JPAUser = JPAUser.class$("org.apache.james.user.jpa.model.JPAUser"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$james$user$jpa$model$JPAUser != null ? class$Lorg$apache$james$user$jpa$model$JPAUser : (class$Lorg$apache$james$user$jpa$model$JPAUser = JPAUser.class$("org.apache.james.user.jpa.model.JPAUser"));
        return new StringId(clazz, this.name);
    }

    private static final String pcGetalg(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.alg;
        }
        int n = pcInheritedFieldCount + 0;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.alg;
    }

    private static final void pcSetalg(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.alg = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 0, jPAUser.alg, string, 0);
    }

    private static final String pcGetname(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.name;
        }
        int n = pcInheritedFieldCount + 1;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.name;
    }

    private static final void pcSetname(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.name = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 1, jPAUser.name, string, 0);
    }

    private static final String pcGetpassword(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.password;
        }
        int n = pcInheritedFieldCount + 2;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.password;
    }

    private static final void pcSetpassword(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.password = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 2, jPAUser.password, string, 0);
    }

    private static final int pcGetversion(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.version;
        }
        int n = pcInheritedFieldCount + 3;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.version;
    }

    private static final void pcSetversion(JPAUser jPAUser, int n) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.version = n;
            return;
        }
        jPAUser.pcStateManager.settingIntField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 3, jPAUser.version, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.version != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

