/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vut.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.james.vut.jpa.model.JPAVirtualUser;
import org.apache.james.vut.lib.AbstractVirtualUserTable;
import org.apache.james.vut.lib.VirtualUserTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAVirtualUserTable
extends AbstractVirtualUserTable {
    private EntityManagerFactory entityManagerFactory;

    @PersistenceUnit
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    protected boolean addMappingInternal(String user, String domain, String regex) {
        String newDomain;
        String newUser = this.getUserString(user);
        Collection map = this.getUserDomainMappings(newUser, newDomain = this.getDomainString(domain));
        if (map != null && map.size() != 0) {
            map.add(regex);
            return this.updateMapping(newUser, newDomain, VirtualUserTableUtil.CollectionToMapping((Collection)map));
        }
        return this.addRawMapping(newUser, newDomain, regex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String mapAddressInternal(String user, String domain) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectMappings").setParameter("user", (Object)user).setParameter("domain", (Object)domain).getResultList();
            transaction.commit();
            if (virtualUsers.size() > 0) {
                String string = ((JPAVirtualUser)virtualUsers.get(0)).getTargetAddress();
                return string;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug((Object)("Failed to find mapping for  user=" + user + " and domain=" + domain), (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getUserDomainMappingsInternal(String user, String domain) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectUserDomainMapping").setParameter("user", (Object)user).setParameter("domain", (Object)domain).getResultList();
            transaction.commit();
            if (virtualUsers.size() > 0) {
                ArrayList arrayList = VirtualUserTableUtil.mappingToCollection((String)((JPAVirtualUser)virtualUsers.get(0)).getTargetAddress());
                return arrayList;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug((Object)"Failed to get user domain mappings", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Collection<String>> getAllMappingsInternal() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        HashMap<String, Collection<String>> mapping = new HashMap<String, Collection<String>>();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectAllMappings").getResultList();
            transaction.commit();
            for (JPAVirtualUser virtualUser : virtualUsers) {
                mapping.put(virtualUser.getUser() + "@" + virtualUser.getDomain(), VirtualUserTableUtil.mappingToCollection((String)virtualUser.getTargetAddress()));
            }
            if (mapping.size() > 0) {
                HashMap<String, Collection<String>> hashMap = mapping;
                return hashMap;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug((Object)"Failed to get all mappings", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return null;
    }

    protected boolean removeMappingInternal(String user, String domain, String mapping) {
        String newDomain;
        String newUser = this.getUserString(user);
        Collection map = this.getUserDomainMappings(newUser, newDomain = this.getDomainString(domain));
        if (map != null && map.size() > 1) {
            map.remove(mapping);
            return this.updateMapping(newUser, newDomain, VirtualUserTableUtil.CollectionToMapping((Collection)map));
        }
        return this.removeRawMapping(newUser, newDomain, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateMapping(String user, String domain, String mapping) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            int updated = entityManager.createNamedQuery("updateMapping").setParameter("targetAddress", (Object)mapping).setParameter("user", (Object)user).setParameter("domain", (Object)domain).executeUpdate();
            transaction.commit();
            if (updated > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug((Object)"Failed to update mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRawMapping(String user, String domain, String mapping) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            int deleted = entityManager.createNamedQuery("deleteMapping").setParameter("user", (Object)user).setParameter("domain", (Object)domain).setParameter("targetAddress", (Object)mapping).executeUpdate();
            transaction.commit();
            if (deleted > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug((Object)"Failed to remove mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addRawMapping(String user, String domain, String mapping) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPAVirtualUser jpaVirtualUser = new JPAVirtualUser(user, domain, mapping);
            entityManager.persist((Object)jpaVirtualUser);
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (PersistenceException e) {
            this.getLogger().debug((Object)"Failed to save virtual user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    private String getUserString(String user) {
        if (user != null) {
            if (user.equals("*") || user.indexOf("@") < 0) {
                return user;
            }
            throw new IllegalArgumentException("Invalid user: " + user);
        }
        return "*";
    }

    private String getDomainString(String domain) {
        if (domain != null) {
            if (domain.equals("*") || domain.indexOf("@") < 0) {
                return domain;
            }
            throw new IllegalArgumentException("Invalid domain: " + domain);
        }
        return "*";
    }
}

