/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.handlers;

import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.atmos.AtmosResponseException;
import org.jclouds.atmos.domain.AtmosError;
import org.jclouds.atmos.reference.AtmosErrorCode;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Strings2;

@Singleton
public class ParseAtmosErrorFromXmlContent
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final AtmosUtils utils;
    public static final Pattern DIRECTORY_PATH = Pattern.compile("^/rest/namespace/?([^/]+)/$");
    public static final Pattern DIRECTORY_KEY_PATH = Pattern.compile("^/rest/namespace/?([^/]+)/(.*)");

    @Inject
    public ParseAtmosErrorFromXmlContent(AtmosUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        HttpResponseException exception = new HttpResponseException(command, response);
        try {
            AtmosError error = null;
            if (response.getPayload() != null) {
                try {
                    String content = Strings2.toStringAndClose((InputStream)response.getPayload().openStream());
                    if (content != null && content.indexOf(60) >= 0) {
                        error = this.utils.parseAtmosErrorFromContent(command, response, Strings2.toInputStream((String)content));
                    } else {
                        exception = content != null ? new HttpResponseException(command, response, content) : exception;
                    }
                }
                catch (IOException e) {
                    this.logger.warn((Throwable)e, "exception reading error from response", new Object[]{response});
                }
            }
            if (error != null && error.getCode() == AtmosErrorCode.RESOURCE_ALREADY_EXISTS.getCode()) {
                File file = new File(command.getCurrentRequest().getEndpoint().getPath());
                exception = new KeyAlreadyExistsException(file.getParentFile().getAbsolutePath(), file.getName());
                return;
            }
            switch (response.getStatusCode()) {
                case 401: {
                    exception = new AuthorizationException(exception.getMessage(), (Throwable)exception);
                    return;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) return;
                    String message = error != null ? error.getMessage() : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    Matcher matcher = DIRECTORY_PATH.matcher(path);
                    if (matcher.find()) {
                        exception = new ContainerNotFoundException(matcher.group(1), message);
                        return;
                    } else {
                        matcher = DIRECTORY_KEY_PATH.matcher(path);
                        if (!matcher.find()) return;
                        exception = new KeyNotFoundException(matcher.group(1), matcher.group(2), message);
                        return;
                    }
                }
                default: {
                    exception = error != null ? new AtmosResponseException(command, response, error) : new HttpResponseException(command, response);
                    return;
                }
            }
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)exception);
        }
    }
}

