/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Set;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class CookbookDefinition {
    private final String name;
    private final URI url;
    private final Set<Version> versions;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"name", "url", "versions"})
    protected CookbookDefinition(String name, URI url, @Nullable Set<Version> versions) {
        this.name = name;
        this.url = url;
        this.versions = CollectionUtils.copyOfOrEmpty(versions);
    }

    public String getName() {
        return this.name;
    }

    public URI getUrl() {
        return this.url;
    }

    public Set<Version> getVersions() {
        return this.versions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.versions == null ? 0 : this.versions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CookbookDefinition other = (CookbookDefinition)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.versions == null ? other.versions != null : !this.versions.equals(other.versions));
    }

    public String toString() {
        return "CookbookDefinition [name=" + this.name + ", url=" + this.url + ", versions=" + this.versions + "]";
    }

    public static class Version {
        private final URI url;
        private final String version;

        public static Builder builder() {
            return new Builder();
        }

        @ConstructorProperties(value={"url", "version"})
        protected Version(URI url, String version) {
            this.url = url;
            this.version = version;
        }

        public URI getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "Version [url=" + this.url + ", version=" + this.version + "]";
        }

        public static class Builder {
            private URI url;
            private String version;

            public Builder url(URI url) {
                this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
                return this;
            }

            public Builder version(String version) {
                this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
                return this;
            }

            public Version build() {
                return new Version(this.url, this.version);
            }
        }
    }

    public static class Builder {
        private String name;
        private URI url;
        private ImmutableSet.Builder<Version> versions = ImmutableSet.builder();

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder url(URI url) {
            this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
            return this;
        }

        public Builder version(Version version) {
            this.versions.add(Preconditions.checkNotNull((Object)version, (Object)"version"));
            return this;
        }

        public Builder versions(Iterable<Version> versions) {
            this.versions.addAll((Iterable)Preconditions.checkNotNull(versions, (Object)"versions"));
            return this;
        }

        public Builder from(CookbookDefinition def) {
            this.url = (URI)Preconditions.checkNotNull((Object)def.getUrl(), (Object)"url");
            this.versions.addAll((Iterable)Preconditions.checkNotNull(def.getVersions(), (Object)"versions"));
            this.name = def.getName();
            return this;
        }

        public CookbookDefinition build() {
            return new CookbookDefinition(this.name, this.url, (Set<Version>)this.versions.build());
        }
    }
}

