/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.features;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.GetMetricStatistics;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.internal.BaseCloudWatchApiExpectTest;
import org.jclouds.cloudwatch.options.GetMetricStatisticsOptions;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MetricApiExpectTest")
public class MetricApiExpectTest
extends BaseCloudWatchApiExpectTest {
    HttpRequest listMetrics = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://monitoring.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"monitoring.us-east-1.amazonaws.com"})).payload(MetricApiExpectTest.payloadFromStringWithContentType((String)"Action=ListMetrics&Signature=KSh9oQydCR0HMAV6QPYwDzqwQIpxs8I/ig7brYgHVZU%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2009-11-08T15%3A54%3A08.897Z&Version=2010-08-01&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    GetMetricStatistics stats = GetMetricStatistics.builder().endTime(new Date(10000000L)).metricName("CPUUtilization").namespace("AWS/EC2").period(60).startTime(new Date(10000000L)).statistic(Statistics.MAXIMUM).statistic(Statistics.MINIMUM).unit(Unit.PERCENT).build();
    HttpRequest getMetricStatistics = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://monitoring.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"monitoring.us-east-1.amazonaws.com"})).payload(MetricApiExpectTest.payloadFromStringWithContentType((String)"Action=GetMetricStatistics&EndTime=1970-01-01T02%3A46%3A40Z&MetricName=CPUUtilization&Namespace=AWS/EC2&Period=60&Signature=rmg8%2Ba7w4ycy/KfO8rnuj6rDL0jNE96m8GKfjh3SWcw%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&StartTime=1970-01-01T02%3A46%3A40Z&Statistics.member.1=Maximum&Statistics.member.2=Minimum&Timestamp=2009-11-08T15%3A54%3A08.897Z&Unit=Percent&Version=2010-08-01&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();

    public MetricApiExpectTest() {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testListMetricsWhenResponseIs2xx() throws Exception {
        HttpResponse listMetricsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/list_metrics.xml", "text/xml"))).build();
        CloudWatchApi apiWhenMetricsExist = (CloudWatchApi)this.requestSendsResponse(this.listMetrics, listMetricsResponse);
        Assert.assertEquals((String)((IterableWithMarker)apiWhenMetricsExist.getMetricApiForRegion(null).list().get(0)).toString(), (String)"[Metric{namespace=AWS/EC2, metricName=CPUUtilization, dimension=[Dimension{name=InstanceId, value=i-689fcf0f}]}]");
    }

    public void testListMetricsWhenResponseIs404() throws Exception {
        HttpResponse listMetricsResponse = HttpResponse.builder().statusCode(404).build();
        CloudWatchApi apiWhenMetricsDontExist = (CloudWatchApi)this.requestSendsResponse(this.listMetrics, listMetricsResponse);
        Assert.assertEquals((Set)((IterableWithMarker)apiWhenMetricsDontExist.getMetricApiForRegion(null).list().get(0)).toSet(), (Set)ImmutableSet.of());
    }

    public void testListMetrics2PagesWhenResponseIs2xx() throws Exception {
        HttpResponse listMetricsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/list_metrics_marker.xml", "text/xml"))).build();
        HttpRequest listMetrics2 = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://monitoring.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"monitoring.us-east-1.amazonaws.com"})).payload(MetricApiExpectTest.payloadFromStringWithContentType((String)"Action=ListMetrics&NextToken=MARKER&Signature=RpBdQydXD1jQhEUnXoqT60NEuCP/ZgdvO6Hf3uf/wy0%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2009-11-08T15%3A54%3A08.897Z&Version=2010-08-01&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
        HttpResponse listMetrics2Response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/list_metrics.xml", "text/xml"))).build();
        CloudWatchApi apiWhenMetricsExist = (CloudWatchApi)this.requestsSendResponses(this.listMetrics, listMetricsResponse, listMetrics2, listMetrics2Response);
        Assert.assertEquals((String)apiWhenMetricsExist.getMetricApiForRegion(null).list().concat().toString(), (String)"[Metric{namespace=AWS/EC2, metricName=CPUUtilization, dimension=[Dimension{name=InstanceId, value=i-689fcf0f}]}, Metric{namespace=AWS/EC2, metricName=CPUUtilization, dimension=[Dimension{name=InstanceId, value=i-689fcf0f}]}]");
    }

    public void testListMetricsWithOptionsWhenResponseIs2xx() throws Exception {
        HttpRequest listMetricsWithOptions = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://monitoring.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"monitoring.us-east-1.amazonaws.com"})).payload(MetricApiExpectTest.payloadFromStringWithContentType((String)"Action=ListMetrics&Dimensions.member.1.Name=InstanceId&Dimensions.member.1.Value=SOMEINSTANCEID&MetricName=CPUUtilization&Namespace=SOMENEXTTOKEN&NextToken=AWS/EC2&Signature=G05HKEx9FJpGZBk02OVYwt3u4g/ilAY9nU5hJI9LDXA%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2009-11-08T15%3A54%3A08.897Z&Version=2010-08-01&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
        HttpResponse listMetricsWithOptionsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/list_metrics.xml", "text/xml"))).build();
        CloudWatchApi apiWhenMetricsWithOptionsExist = (CloudWatchApi)this.requestSendsResponse(listMetricsWithOptions, listMetricsWithOptionsResponse);
        Assert.assertEquals((String)apiWhenMetricsWithOptionsExist.getMetricApiForRegion(null).list(ListMetricsOptions.Builder.dimension((Dimension)new Dimension("InstanceId", "SOMEINSTANCEID")).metricName("CPUUtilization").namespace("SOMENEXTTOKEN").afterMarker((Object)"AWS/EC2")).toString(), (String)"[Metric{namespace=AWS/EC2, metricName=CPUUtilization, dimension=[Dimension{name=InstanceId, value=i-689fcf0f}]}]");
    }

    public void testGetMetricStatisticsWhenResponseIs2xx() throws Exception {
        HttpResponse getMetricStatisticsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/get_metric_statistics.xml", "text/xml"))).build();
        CloudWatchApi apiWhenMetricsExist = (CloudWatchApi)this.requestSendsResponse(this.getMetricStatistics, getMetricStatisticsResponse);
        Assert.assertEquals((String)apiWhenMetricsExist.getMetricApiForRegion(null).getMetricStatistics(this.stats).toString(), (String)"GetMetricStatisticsResponse{label=CPUUtilization, datapoints=[Datapoint{timestamp=Thu Jan 15 16:00:00 PST 2009, customUnit=null, maximum=null, minimum=null, average=0.17777777777777778, sum=null, samples=9.0, unit=Percent}, Datapoint{timestamp=Thu Jan 15 16:01:00 PST 2009, customUnit=null, maximum=null, minimum=null, average=0.1, sum=null, samples=8.0, unit=Percent}]}");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testGetMetricStatisticsWhenResponseIs404() throws Exception {
        HttpResponse getMetricStatisticsResponse = HttpResponse.builder().statusCode(404).build();
        CloudWatchApi apiWhenMetricsDontExist = (CloudWatchApi)this.requestSendsResponse(this.getMetricStatistics, getMetricStatisticsResponse);
        apiWhenMetricsDontExist.getMetricApiForRegion(null).getMetricStatistics(this.stats);
    }

    public void testGetMetricStatisticsWithOptionsWhenResponseIs2xx() throws Exception {
        HttpRequest getMetricStatistics = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://monitoring.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"monitoring.us-east-1.amazonaws.com"})).payload(MetricApiExpectTest.payloadFromStringWithContentType((String)"Action=GetMetricStatistics&Dimensions.member.1.Name=InstanceId&Dimensions.member.1.Value=SOMEINSTANCEID&Dimensions.member.2.Name=InstanceType&Dimensions.member.2.Value=t1.micro&EndTime=1970-01-01T02%3A46%3A40Z&MetricName=CPUUtilization&Namespace=AWS/EC2&Period=60&Signature=e0WyI/Nm4hN2%2BMEm1mjRUzsvgvMCdFXbVJWi4ORpwic%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&StartTime=1970-01-01T02%3A46%3A40Z&Statistics.member.1=Maximum&Statistics.member.2=Minimum&Timestamp=2009-11-08T15%3A54%3A08.897Z&Unit=Percent&Version=2010-08-01&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
        HttpResponse getMetricStatisticsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/get_metric_statistics.xml", "text/xml"))).build();
        CloudWatchApi apiWhenMetricsExist = (CloudWatchApi)this.requestSendsResponse(getMetricStatistics, getMetricStatisticsResponse);
        Dimension dimension1 = new Dimension("InstanceId", "SOMEINSTANCEID");
        Dimension dimension2 = new Dimension("InstanceType", "t1.micro");
        Assert.assertEquals((String)apiWhenMetricsExist.getMetricApiForRegion(null).getMetricStatistics(this.stats, GetMetricStatisticsOptions.Builder.dimension((Dimension)dimension1).dimension(dimension2)).toString(), (String)"GetMetricStatisticsResponse{label=CPUUtilization, datapoints=[Datapoint{timestamp=Thu Jan 15 16:00:00 PST 2009, customUnit=null, maximum=null, minimum=null, average=0.17777777777777778, sum=null, samples=9.0, unit=Percent}, Datapoint{timestamp=Thu Jan 15 16:01:00 PST 2009, customUnit=null, maximum=null, minimum=null, average=0.1, sum=null, samples=8.0, unit=Percent}]}");
    }
}

