/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.xml.MetricAlarmHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Beta
public class ListAlarmsForMetricResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Iterable<Alarm>> {
    private final MetricAlarmHandler metricAlarmHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<Alarm> alarms = Sets.newLinkedHashSet();
    private boolean inMetricAlarms;

    @Inject
    public ListAlarmsForMetricResponseHandler(MetricAlarmHandler metricAlarmHandler) {
        this.metricAlarmHandler = metricAlarmHandler;
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"MetricAlarms")) {
            this.inMetricAlarms = true;
        }
        if (this.inMetricAlarms) {
            this.metricAlarmHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.inMetricAlarms) {
            if (qName.equals("MetricAlarms")) {
                this.inMetricAlarms = false;
            } else if (qName.equals("member") && !this.metricAlarmHandler.shouldHandleMemberTag()) {
                this.alarms.add(this.metricAlarmHandler.getResult());
            } else {
                this.metricAlarmHandler.endElement(uri, name, qName);
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inMetricAlarms) {
            this.metricAlarmHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    public FluentIterable<Alarm> getResult() {
        FluentIterable result = FluentIterable.from(this.alarms);
        this.alarms = Sets.newLinkedHashSet();
        return result;
    }
}

