/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.cloudwatch.domain.HistoryItemType;

@Beta
public class AlarmHistoryItem {
    private final String alarmName;
    private final String historyData;
    private final HistoryItemType historyItemType;
    private final String historySummary;
    private final Date timestamp;

    public AlarmHistoryItem(String alarmName, String historyData, HistoryItemType historyItemType, String historySummary, Date timestamp) {
        this.alarmName = (String)Preconditions.checkNotNull((Object)alarmName, (Object)"alarmName");
        this.historyData = (String)Preconditions.checkNotNull((Object)historyData, (String)"historyData for %s", (Object[])new Object[]{alarmName});
        this.historyItemType = (HistoryItemType)((Object)Preconditions.checkNotNull((Object)((Object)historyItemType), (String)"historyItemType for %s", (Object[])new Object[]{alarmName}));
        this.historySummary = (String)Preconditions.checkNotNull((Object)historySummary, (String)"historySummary for %s", (Object[])new Object[]{alarmName});
        this.timestamp = (Date)Preconditions.checkNotNull((Object)timestamp, (String)"timestamp for %s", (Object[])new Object[]{alarmName});
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public String getHistoryData() {
        return this.historyData;
    }

    public HistoryItemType getHistoryItemType() {
        return this.historyItemType;
    }

    public String getHistorySummary() {
        return this.historySummary;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alarmName, this.historyData, this.historyItemType, this.historySummary, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlarmHistoryItem other = (AlarmHistoryItem)obj;
        return Objects.equal((Object)this.alarmName, (Object)other.alarmName) && Objects.equal((Object)this.historyData, (Object)other.historyData) && Objects.equal((Object)((Object)this.historyItemType), (Object)((Object)other.historyItemType)) && Objects.equal((Object)this.historySummary, (Object)other.historySummary) && Objects.equal((Object)this.timestamp, (Object)other.timestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("alarmName", (Object)this.alarmName).add("historyData", (Object)this.historyData).add("historyItemType", (Object)this.historyItemType).add("historySummary", (Object)this.historySummary).add("timestamp", (Object)this.timestamp).toString();
    }
}

