/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

@Beta
public class SaveAlarmOptions
extends BaseHttpRequestOptions {
    int alarmActionIndex = 1;
    int dimensionIndex = 1;
    int insufficientDataActionsIndex = 1;
    int okActionsIndex = 1;

    public SaveAlarmOptions actionsEnabled(boolean actionsEnabled) {
        this.formParameters.put((Object)"ActionsEnabled", (Object)String.valueOf(actionsEnabled));
        return this;
    }

    public SaveAlarmOptions alarmActions(Set<String> alarmActions) {
        for (String alarmAction : (Set)Preconditions.checkNotNull(alarmActions, (Object)"alarmActions")) {
            this.alarmAction(alarmAction);
        }
        return this;
    }

    public SaveAlarmOptions alarmAction(String alarmAction) {
        Preconditions.checkArgument((this.alarmActionIndex <= 5 ? 1 : 0) != 0, (Object)"maximum number of alarm actions is 5");
        this.formParameters.put((Object)("AlarmActions.member." + this.alarmActionIndex), Preconditions.checkNotNull((Object)alarmAction, (Object)"alarmAction"));
        ++this.alarmActionIndex;
        return this;
    }

    public SaveAlarmOptions alarmDescription(String alarmDescription) {
        this.formParameters.put((Object)"AlarmDescription", Preconditions.checkNotNull((Object)alarmDescription, (Object)"alarmDescription"));
        return this;
    }

    public SaveAlarmOptions alarmName(String alarmName) {
        this.formParameters.put((Object)"AlarmName", Preconditions.checkNotNull((Object)alarmName, (Object)"alarmName"));
        return this;
    }

    public SaveAlarmOptions comparisonOperator(ComparisonOperator comparisonOperator) {
        Preconditions.checkNotNull((Object)((Object)comparisonOperator), (Object)"comparisonOperator");
        Preconditions.checkArgument((comparisonOperator != ComparisonOperator.UNRECOGNIZED ? 1 : 0) != 0, (Object)"comparisonOperator unrecognized");
        this.formParameters.put((Object)"ComparisonOperator", (Object)comparisonOperator.toString());
        return this;
    }

    public SaveAlarmOptions dimensions(Set<Dimension> dimensions) {
        for (Dimension dimension : (Set)Preconditions.checkNotNull(dimensions, (Object)"dimensions")) {
            this.dimension(dimension);
        }
        return this;
    }

    public SaveAlarmOptions dimension(Dimension dimension) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkArgument((this.dimensionIndex <= 10 ? 1 : 0) != 0, (Object)"maximum number of dimensions is 10");
        this.formParameters.put((Object)("Dimensions.member." + this.dimensionIndex + ".Name"), (Object)dimension.getName());
        this.formParameters.put((Object)("Dimensions.member." + this.dimensionIndex + ".Value"), (Object)dimension.getValue());
        ++this.dimensionIndex;
        return this;
    }

    public SaveAlarmOptions evaluationPeriods(int evaluationPeriods) {
        this.formParameters.put((Object)"EvaluationPeriods", (Object)String.valueOf(evaluationPeriods));
        return this;
    }

    public SaveAlarmOptions insufficientDataActions(Set<String> insufficientDataActions) {
        for (String insufficientDataAction : (Set)Preconditions.checkNotNull(insufficientDataActions)) {
            this.insufficientDataAction(insufficientDataAction);
        }
        return this;
    }

    public SaveAlarmOptions insufficientDataAction(String insufficientDataAction) {
        Preconditions.checkNotNull((Object)insufficientDataAction, (Object)"insufficientDataAction");
        Preconditions.checkArgument((this.insufficientDataActionsIndex <= 5 ? 1 : 0) != 0, (Object)"maximum number of insufficient data actions is 5");
        this.formParameters.put((Object)("InsufficientDataActions.member." + this.insufficientDataActionsIndex), (Object)insufficientDataAction);
        ++this.insufficientDataActionsIndex;
        return this;
    }

    public SaveAlarmOptions metricName(String metricName) {
        this.formParameters.put((Object)"MetricName", Preconditions.checkNotNull((Object)metricName, (Object)"metricName"));
        return this;
    }

    public SaveAlarmOptions namespace(String namespace) {
        this.formParameters.put((Object)"Namespace", Preconditions.checkNotNull((Object)namespace));
        return this;
    }

    public SaveAlarmOptions okActions(Set<String> okActions) {
        for (String okAction : (Set)Preconditions.checkNotNull(okActions, (Object)"okActions")) {
            this.okAction(okAction);
        }
        return this;
    }

    public SaveAlarmOptions okAction(String okAction) {
        Preconditions.checkNotNull((Object)okAction, (Object)"okAction");
        Preconditions.checkArgument((this.okActionsIndex <= 5 ? 1 : 0) != 0, (Object)"maximum number of ok actions is 5");
        this.formParameters.put((Object)("OKActions.member." + this.okActionsIndex), (Object)okAction);
        ++this.okActionsIndex;
        return this;
    }

    public SaveAlarmOptions period(int period) {
        this.formParameters.put((Object)"Period", (Object)String.valueOf(period));
        return this;
    }

    public SaveAlarmOptions statistic(Statistics statistic) {
        Preconditions.checkNotNull((Object)((Object)statistic), (Object)"statistic");
        Preconditions.checkArgument((statistic != Statistics.UNRECOGNIZED ? 1 : 0) != 0, (Object)"statistic unrecognized");
        this.formParameters.put((Object)"Statistic", (Object)statistic.toString());
        return this;
    }

    public SaveAlarmOptions threshold(double threshold) {
        this.formParameters.put((Object)"Threshold", (Object)String.valueOf(threshold));
        return this;
    }

    public SaveAlarmOptions unit(Unit unit) {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        Preconditions.checkArgument((unit != Unit.UNRECOGNIZED ? 1 : 0) != 0, (Object)"unit unrecognized");
        this.formParameters.put((Object)"Unit", (Object)unit.toString());
        return this;
    }
}

