/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.features.SecurityGroupApi;

@Singleton
public class EC2SecurityGroupIdFromName
implements Function<String, String> {
    protected EC2Api api;

    @Inject
    public EC2SecurityGroupIdFromName(EC2Api api) {
        this.api = (EC2Api)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    public String apply(String input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        String[] parts = AWSUtils.parseHandle((String)input);
        String region = parts[0];
        String name = parts[1];
        return ((SecurityGroup)((Object)Iterables.getOnlyElement(((SecurityGroupApi)this.api.getSecurityGroupApi().get()).describeSecurityGroupsInRegion(region, name), null))).getId();
    }
}

