/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class Tag {
    protected final String resourceId;
    protected final String resourceType;
    protected final String key;
    protected final Optional<String> value;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Tag.builder().fromTag(this);
    }

    protected Tag(String resourceId, String resourceType, String key, Optional<String> value) {
        this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId");
        this.resourceType = (String)Preconditions.checkNotNull((Object)resourceType, (Object)"resourceType");
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.value = (Optional)Preconditions.checkNotNull(value, (Object)"value");
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resourceId, this.key});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equal((Object)this.resourceId, (Object)other.resourceId) && Objects.equal((Object)this.key, (Object)other.key);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("resourceId", (Object)this.resourceId).add("resourceType", (Object)this.resourceType).add("key", (Object)this.key).add("value", this.value.orNull());
    }

    public static class Builder {
        protected String resourceId;
        protected String resourceType;
        protected String key;
        protected Optional<String> value = Optional.absent();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = Optional.fromNullable((Object)value);
            return this;
        }

        public Tag build() {
            return new Tag(this.resourceId, this.resourceType, this.key, this.value);
        }

        public Builder fromTag(Tag in) {
            return this.resourceId(in.getResourceId()).resourceType(in.getResourceType()).key(in.getKey()).value((String)in.getValue().orNull());
        }
    }

    public static interface ResourceType {
        public static final String CUSTOMER_GATEWAY = "customer-gateway";
        public static final String DHCP_OPTIONS = "dhcp-options";
        public static final String IMAGE = "image";
        public static final String INSTANCE = "instance";
        public static final String INTERNET_GATEWAY = "internet-gateway";
        public static final String NETWORK_ACL = "network-acl";
        public static final String RESERVED_INSTANCES = "reserved-instances";
        public static final String ROUTE_TABLE = "route-table";
        public static final String SECURITY_GROUP = "security-group";
        public static final String SNAPSHOT = "snapshot";
        public static final String SPOT_INSTANCES_REQUEST = "spot-instances-request";
        public static final String SUBNET = "subnet";
        public static final String VOLUME = "volume";
        public static final String VPC = "vpc";
        public static final String VPN_CONNECTION = "vpn-connection";
        public static final String VPN_GATEWAY = "vpn-gateway";
    }
}

