/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.inject.Singleton;
import org.jclouds.glacier.blobstore.strategy.PayloadSlice;
import org.jclouds.glacier.blobstore.strategy.SlicingStrategy;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;

@Singleton
public class BaseSlicingStrategy
implements SlicingStrategy {
    public static final double DEFAULT_RATIO = 0.32;
    @Inject(optional=true)
    @Named(value="jclouds.mpu.part.ratio")
    private double ratio = 0.32;
    private final PayloadSlicer slicer;
    private Payload payload;
    private volatile long partSizeInMB;
    private volatile long total;
    private volatile long copied;
    private volatile int part;

    @Inject
    public BaseSlicingStrategy(PayloadSlicer slicer) {
        this.slicer = (PayloadSlicer)Preconditions.checkNotNull((Object)slicer, (Object)"slicer");
        this.total = 0L;
        this.copied = 0L;
        this.partSizeInMB = 0L;
        this.part = 0;
    }

    protected long calculatePartSize(long length) {
        long lengthInMB = length / 0x100000L + 1L;
        double fpPartSizeInMB = Math.sqrt(this.ratio * (double)lengthInMB);
        long partSizeInMB = Long.highestOneBit((long)fpPartSizeInMB - 1L) << 1;
        if (partSizeInMB < 1L) {
            return 1L;
        }
        if (partSizeInMB > 0x100000000L) {
            return 0x100000000L;
        }
        return partSizeInMB;
    }

    public long getRemaining() {
        return this.total - this.copied;
    }

    @Override
    public void startSlicing(Payload payload) {
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload, (Object)"payload");
        this.copied = 0L;
        this.total = (Long)Preconditions.checkNotNull((Object)payload.getContentMetadata().getContentLength(), (Object)"contentLength");
        this.partSizeInMB = this.calculatePartSize(this.total);
        this.part = 0;
    }

    @Override
    public PayloadSlice nextSlice() {
        Preconditions.checkNotNull((Object)this.payload, (Object)"payload");
        long sliceLength = Math.min(this.getRemaining(), this.partSizeInMB << 20);
        Payload slicedPayload = this.slicer.slice(this.payload, this.copied, sliceLength);
        ContentRange range = ContentRange.build(this.copied, this.copied + sliceLength - 1L);
        this.copied += sliceLength;
        ++this.part;
        return new PayloadSlice(slicedPayload, range, this.part);
    }

    @Override
    public boolean hasNext() {
        return this.getRemaining() != 0L;
    }

    @Override
    public long getPartSizeInMB() {
        return this.partSizeInMB;
    }
}

