/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.TemporaryUrlSigner;
import org.jclouds.openstack.swift.v1.features.AccountApi;
import org.jclouds.openstack.swift.v1.features.AccountApiMockTest;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TemporaryUrlSignerMockTest")
public class TemporaryUrlSignerMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="accountApi")
    public void whenAccountApiIsNull() {
        TemporaryUrlSigner.checkApiEvery(null, (long)10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whenAccountApiHasKey() throws Exception {
        MockWebServer server = TemporaryUrlSignerMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse().addHeader("X-Account-Meta-Temp-Url-Key", (Object)"mykey")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            String signature = TemporaryUrlSigner.checkApiEvery((AccountApi)api.getAccountApi("DFW"), (long)10000L).sign("GET", "/v1/AUTH_account/container/object", 1323479485L);
            Assert.assertEquals((String)signature, (String)"d9fc2067e52b06598421664cf6610bfc8fc431f6");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"HEAD /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp=".*returned a null temporaryUrlKey!")
    public void whenAccountApiDoesntHaveKey() throws Exception {
        MockWebServer server = TemporaryUrlSignerMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse()));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            TemporaryUrlSigner.checkApiEvery((AccountApi)api.getAccountApi("DFW"), (long)10000L).sign("GET", "/v1/AUTH_account/container/object", 1323479485L);
        }
        finally {
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"HEAD /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9 HTTP/1.1");
            server.shutdown();
        }
    }
}

