/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.ImmutableMap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.Map;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Account;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccountApiMockTest")
public class AccountApiMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    private static final Map<String, String> metadata = ImmutableMap.of((Object)"ApiName", (Object)"swift", (Object)"ApiVersion", (Object)"v1.1");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getKnowingServerMessesWithMetadataKeyCaseFormat() throws Exception {
        MockWebServer server = AccountApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse().addHeader("X-Account-Meta-Apiname", (Object)"swift").addHeader("X-Account-Meta-Apiversion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Account account = api.getAccountApi("DFW").get();
            Assert.assertEquals((long)account.getContainerCount(), (long)3L);
            Assert.assertEquals((long)account.getObjectCount(), (long)42L);
            Assert.assertEquals((long)account.getBytesUsed(), (long)323479L);
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)((String)account.getMetadata().get(entry.getKey().toLowerCase())), (String)entry.getValue());
            }
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "HEAD", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetadata() throws Exception {
        MockWebServer server = AccountApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse().addHeader("X-Account-Meta-ApiName", (Object)"swift").addHeader("X-Account-Meta-ApiVersion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getAccountApi("DFW").updateMetadata(metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest replaceRequest = server.takeRequest();
            this.assertRequest(replaceRequest, "POST", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)replaceRequest.getHeader("X-Account-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemporaryUrlKey() throws Exception {
        MockWebServer server = AccountApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse()));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getAccountApi("DFW").updateTemporaryUrlKey("foobar"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest replaceRequest = server.takeRequest();
            this.assertRequest(replaceRequest, "POST", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9");
            Assert.assertEquals((String)replaceRequest.getHeader("X-Account-Meta-Temp-Url-Key"), (String)"foobar");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMetadata() throws Exception {
        MockWebServer server = AccountApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse()));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getAccountApi("DFW").deleteMetadata(metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"POST /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9 HTTP/1.1");
            for (String key : metadata.keySet()) {
                Assert.assertEquals((String)deleteRequest.getHeader("X-Remove-Account-Meta-" + key.toLowerCase()), (String)"ignored");
            }
        }
        finally {
            server.shutdown();
        }
    }

    public static MockResponse accountResponse() {
        return new MockResponse().addHeader("X-Account-Container-Count", (Object)"3").addHeader("X-Account-Object-Count", (Object)"42").addHeader("X-Account-Bytes-Used", (Object)"323479");
    }
}

