/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.TarGzExporter;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.BulkDeleteResponse;
import org.jclouds.openstack.swift.v1.domain.ExtractArchiveResponse;
import org.jclouds.openstack.swift.v1.internal.BaseSwiftApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="BulkApiLiveTest")
public class BulkApiLiveTest
extends BaseSwiftApiLiveTest<SwiftApi> {
    private static final int OBJECT_COUNT = 10;
    private String containerName = ((Object)((Object)this)).getClass().getSimpleName();
    List<String> paths = Lists.newArrayList();
    byte[] tarGz;

    public void testNotPresentWhenDeleting() throws Exception {
        for (String regionId : this.regions) {
            BulkDeleteResponse deleteResponse = ((SwiftApi)this.api).getBulkApi(regionId).bulkDelete((Iterable)ImmutableList.of((Object)UUID.randomUUID().toString()));
            Assert.assertEquals((int)deleteResponse.getDeleted(), (int)0);
            Assert.assertEquals((int)deleteResponse.getNotFound(), (int)1);
            Assert.assertTrue((boolean)deleteResponse.getErrors().isEmpty());
        }
    }

    public void testExtractArchive() throws Exception {
        for (String regionId : this.regions) {
            ByteSourcePayload payload = new ByteSourcePayload(ByteSource.wrap((byte[])this.tarGz));
            ExtractArchiveResponse extractResponse = ((SwiftApi)this.api).getBulkApi(regionId).extractArchive(this.containerName, (Payload)payload, "tar.gz");
            Assert.assertEquals((int)extractResponse.getCreated(), (int)10);
            Assert.assertTrue((boolean)extractResponse.getErrors().isEmpty());
            Assert.assertEquals((long)((SwiftApi)this.api).getContainerApi(regionId).get(this.containerName).getObjectCount(), (long)10L);
            extractResponse = ((SwiftApi)this.api).getBulkApi(regionId).extractArchive(this.containerName, (Payload)payload, "tar.gz");
            Assert.assertEquals((int)extractResponse.getCreated(), (int)10);
            Assert.assertTrue((boolean)extractResponse.getErrors().isEmpty());
        }
    }

    @Test(dependsOnMethods={"testExtractArchive"})
    public void testBulkDelete() throws Exception {
        for (String regionId : this.regions) {
            BulkDeleteResponse deleteResponse = ((SwiftApi)this.api).getBulkApi(regionId).bulkDelete(this.paths);
            Assert.assertEquals((int)deleteResponse.getDeleted(), (int)10);
            Assert.assertEquals((int)deleteResponse.getNotFound(), (int)0);
            Assert.assertTrue((boolean)deleteResponse.getErrors().isEmpty());
            Assert.assertEquals((long)((SwiftApi)this.api).getContainerApi(regionId).get(this.containerName).getObjectCount(), (long)0L);
        }
    }

    @Override
    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        for (String regionId : this.regions) {
            boolean created = ((SwiftApi)this.api).getContainerApi(regionId).create(this.containerName);
            if (created) continue;
            this.deleteAllObjectsInContainer(regionId, this.containerName);
        }
        GenericArchive files = (GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"files.tar.gz");
        StringAsset content = new StringAsset("foo");
        for (int i = 0; i < 10; ++i) {
            this.paths.add(this.containerName + "/file" + i);
            files.add((Asset)content, "/file" + i);
        }
        try {
            this.tarGz = ByteStreams2.toByteArrayAndClose((InputStream)((TarGzExporter)files.as(TarGzExporter.class)).exportAsInputStream());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @AfterClass(groups={"live"})
    public void tearDown() {
        for (String regionId : this.regions) {
            this.deleteAllObjectsInContainer(regionId, this.containerName);
            ((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.containerName);
        }
        super.tearDown();
    }
}

