/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.io.ByteSource;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.TarGzExporter;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.ExtractArchiveResponse;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BulkApiMockTest")
public class BulkApiMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtractArchive() throws Exception {
        GenericArchive files = (GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"files.tar.gz");
        StringAsset content = new StringAsset("foo");
        for (int i = 0; i < 10; ++i) {
            files.add((Asset)content, "/file" + i);
        }
        byte[] tarGz = ByteStreams2.toByteArrayAndClose((InputStream)((TarGzExporter)files.as(TarGzExporter.class)).exportAsInputStream());
        MockWebServer server = BulkApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).setBody("{\"Number Files Created\": 10, \"Errors\": []}")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])tarGz));
            ExtractArchiveResponse response = api.getBulkApi("DFW").extractArchive("myContainer", (Payload)payload, "tar.gz");
            Assert.assertEquals((int)response.getCreated(), (int)10);
            Assert.assertTrue((boolean)response.getErrors().isEmpty());
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest extractRequest = server.takeRequest();
            this.assertRequest(extractRequest, "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer?extract-archive=tar.gz");
            Assert.assertEquals((byte[])extractRequest.getBody(), (byte[])tarGz);
        }
        finally {
            server.shutdown();
        }
    }
}

