/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.features.ContainerApi;
import org.jclouds.openstack.swift.v1.internal.BaseSwiftApiLiveTest;
import org.jclouds.openstack.swift.v1.options.CreateContainerOptions;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.jclouds.openstack.swift.v1.options.UpdateContainerOptions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ContainerApiLiveTest")
public class ContainerApiLiveTest
extends BaseSwiftApiLiveTest<SwiftApi> {
    private String name = ((Object)((Object)this)).getClass().getSimpleName();

    public void testCreateWithOptions() throws Exception {
        for (String regionId : this.regions) {
            ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Index", (Object)"__index.html", (Object)"X-Container-Meta-Web-Error", (Object)"__error.html");
            CreateContainerOptions opts = new CreateContainerOptions().headers((Multimap)headers);
            Assert.assertNotNull((Object)((SwiftApi)this.api).getContainerApi(regionId).create(this.name, opts));
            Container container = ((SwiftApi)this.api).getContainerApi(regionId).get(this.name);
            Assert.assertNotNull((Object)container);
            Assert.assertEquals((String)container.getName(), (String)this.name);
            Assert.assertEquals((int)container.getMetadata().size(), (int)2);
            Assert.assertEquals((String)((String)container.getMetadata().get("web-index")), (String)"__index.html");
            Assert.assertEquals((String)((String)container.getMetadata().get("web-error")), (String)"__error.html");
            Assert.assertTrue((boolean)((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.name));
        }
    }

    public void testCreateWithSpacesAndSpecialCharacters() throws Exception {
        String nameWithSpaces = "container # ! special";
        for (String regionId : this.regions) {
            Assert.assertTrue((boolean)((SwiftApi)this.api).getContainerApi(regionId).create("container # ! special"));
            Container container = ((SwiftApi)this.api).getContainerApi(regionId).get("container # ! special");
            Assert.assertNotNull((Object)container);
            Assert.assertEquals((String)container.getName(), (String)"container # ! special");
            Assert.assertTrue((boolean)((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty("container # ! special"));
        }
    }

    public void testList() throws Exception {
        for (String regionId : this.regions) {
            ContainerApi containerApi = ((SwiftApi)this.api).getContainerApi(regionId);
            FluentIterable response = containerApi.list();
            Assert.assertNotNull((Object)response);
            for (Container container : response) {
                Assert.assertNotNull((Object)container.getName());
                Assert.assertTrue((container.getObjectCount() >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((container.getBytesUsed() >= 0L ? 1 : 0) != 0);
            }
        }
    }

    public void testListWithOptions() throws Exception {
        String lexicographicallyBeforeName = this.name.substring(0, this.name.length() - 1);
        for (String regionId : this.regions) {
            ListContainerOptions options = ListContainerOptions.Builder.marker((String)lexicographicallyBeforeName);
            Container container = (Container)((SwiftApi)this.api).getContainerApi(regionId).list(options).get(0);
            Assert.assertEquals((String)container.getName(), (String)this.name);
            Assert.assertTrue((container.getObjectCount() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((container.getBytesUsed() == 0L ? 1 : 0) != 0);
        }
    }

    public void testUpdate() throws Exception {
        for (String regionId : this.regions) {
            ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Index", (Object)"__index.html", (Object)"X-Container-Meta-Web-Error", (Object)"__error.html");
            UpdateContainerOptions opts = new UpdateContainerOptions().headers((Multimap)headers);
            Assert.assertNotNull((Object)((SwiftApi)this.api).getContainerApi(regionId).create(this.name));
            Container container = ((SwiftApi)this.api).getContainerApi(regionId).get(this.name);
            Assert.assertNotNull((Object)container);
            Assert.assertEquals((String)container.getName(), (String)this.name);
            Assert.assertTrue((boolean)container.getMetadata().isEmpty());
            Assert.assertNotNull((Object)((SwiftApi)this.api).getContainerApi(regionId).update(this.name, opts));
            Container updatedContainer = ((SwiftApi)this.api).getContainerApi(regionId).get(this.name);
            Assert.assertNotNull((Object)updatedContainer);
            Assert.assertEquals((String)updatedContainer.getName(), (String)this.name);
            Assert.assertEquals((int)updatedContainer.getMetadata().size(), (int)2);
            Assert.assertEquals((String)((String)updatedContainer.getMetadata().get("web-index")), (String)"__index.html");
            Assert.assertEquals((String)((String)updatedContainer.getMetadata().get("web-error")), (String)"__error.html");
            Assert.assertTrue((boolean)((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.name));
        }
    }

    public void testGet() throws Exception {
        for (String regionId : this.regions) {
            Container container = ((SwiftApi)this.api).getContainerApi(regionId).get(this.name);
            Assert.assertEquals((String)container.getName(), (String)this.name);
            Assert.assertTrue((container.getObjectCount() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((container.getBytesUsed() == 0L ? 1 : 0) != 0);
        }
    }

    public void testUpdateMetadata() throws Exception {
        ImmutableMap meta = ImmutableMap.of((Object)"MyAdd1", (Object)"foo", (Object)"MyAdd2", (Object)"bar");
        for (String regionId : this.regions) {
            ContainerApi containerApi = ((SwiftApi)this.api).getContainerApi(regionId);
            Assert.assertTrue((boolean)containerApi.updateMetadata(this.name, (Map)meta));
            ContainerApiLiveTest.containerHasMetadata(containerApi, this.name, (Map<String, String>)meta);
        }
    }

    public void testDeleteMetadata() throws Exception {
        ImmutableMap meta = ImmutableMap.of((Object)"MyDelete1", (Object)"foo", (Object)"MyDelete2", (Object)"bar");
        for (String regionId : this.regions) {
            ContainerApi containerApi = ((SwiftApi)this.api).getContainerApi(regionId);
            Assert.assertTrue((boolean)containerApi.updateMetadata(this.name, (Map)meta));
            ContainerApiLiveTest.containerHasMetadata(containerApi, this.name, (Map<String, String>)meta);
            Assert.assertTrue((boolean)containerApi.deleteMetadata(this.name, (Map)meta));
            Container container = containerApi.get(this.name);
            for (Map.Entry entry : meta.entrySet()) {
                Assert.assertFalse((boolean)container.getMetadata().containsKey(((String)entry.getKey()).toLowerCase()));
            }
        }
    }

    static void containerHasMetadata(ContainerApi containerApi, String name, Map<String, String> meta) {
        Container container = containerApi.get(name);
        for (Map.Entry<String, String> entry : meta.entrySet()) {
            Assert.assertEquals((String)((String)container.getMetadata().get(entry.getKey().toLowerCase())), (String)entry.getValue(), (String)(container + " didn't have metadata: " + entry));
        }
    }

    @Override
    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        for (String regionId : this.regions) {
            ((SwiftApi)this.api).getContainerApi(regionId).create(this.name);
        }
    }

    @AfterClass(groups={"live"})
    public void tearDown() {
        for (String regionId : this.regions) {
            ((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.name);
        }
        super.tearDown();
    }
}

