/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.Collection;
import java.util.Map;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.options.CreateContainerOptions;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ContainerApiMockTest")
public class ContainerApiMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    private static final Map<String, String> metadata = ImmutableMap.of((Object)"ApiName", (Object)"swift", (Object)"ApiVersion", (Object)"v1.1");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testList() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/container_list.json"))));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            ImmutableList containers = api.getContainerApi("DFW").list().toList();
            Assert.assertEquals((Collection)containers, (Collection)ImmutableList.of((Object)Container.builder().name("test_container_1").objectCount(2L).bytesUsed(78L).build(), (Object)Container.builder().name("test_container_2").objectCount(1L).bytesUsed(17L).build()));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "GET", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListWithOptions() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/container_list.json"))));
        ListContainerOptions options = ListContainerOptions.Builder.marker((String)"test");
        Assert.assertNotNull((Object)options);
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            ImmutableList containers = api.getContainerApi("DFW").list(options).toList();
            Assert.assertEquals((Collection)containers, (Collection)ImmutableList.of((Object)Container.builder().name("test_container_1").objectCount(2L).bytesUsed(78L).build(), (Object)Container.builder().name("test_container_2").objectCount(1L).bytesUsed(17L).build()));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "GET", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9?marker=test");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContainerExists() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201)));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse().addHeader("X-Container-Meta-ApiName", (Object)"swift").addHeader("X-Container-Meta-ApiVersion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").create("myContainer", CreateContainerOptions.Builder.anybodyRead().metadata(metadata)));
            Container container = api.getContainerApi("DFW").get("myContainer");
            Assert.assertEquals((String)container.getName(), (String)"myContainer");
            Assert.assertEquals((long)container.getObjectCount(), (long)42L);
            Assert.assertEquals((long)container.getBytesUsed(), (long)323479L);
            for (Map.Entry entry : container.getMetadata().entrySet()) {
                Assert.assertEquals((String)((String)container.getMetadata().get(((String)entry.getKey()).toLowerCase())), (String)((String)entry.getValue()));
            }
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
            this.assertRequest(server.takeRequest(), "HEAD", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testContainerDoesNotExist() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").create("myContainer", CreateContainerOptions.Builder.anybodyRead().metadata(metadata)));
            api.getContainerApi("DFW").get("myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreate() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").create("myContainer"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateWithOptions() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").create("myContainer", CreateContainerOptions.Builder.anybodyRead().metadata(metadata)));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest createRequest = server.takeRequest();
            this.assertRequest(createRequest, "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
            Assert.assertEquals((String)createRequest.getHeader("X-Container-Read"), (String)".r:*,.rlistings");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)createRequest.getHeader("X-Container-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateWithSpacesAndSpecialCharacters() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").create("container # ! special"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/container%20%23%20%21%20special");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlreadyCreated() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(202)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertFalse((boolean)api.getContainerApi("DFW").create("myContainer"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetKnowingServerMessesWithMetadataKeyCaseFormat() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse().addHeader("X-Container-Meta-Apiname", (Object)"swift").addHeader("X-Container-Meta-Apiversion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Container container = api.getContainerApi("DFW").get("myContainer");
            Assert.assertEquals((String)container.getName(), (String)"myContainer");
            Assert.assertEquals((long)container.getObjectCount(), (long)42L);
            Assert.assertEquals((long)container.getBytesUsed(), (long)323479L);
            for (Map.Entry entry : container.getMetadata().entrySet()) {
                Assert.assertEquals((String)((String)container.getMetadata().get(((String)entry.getKey()).toLowerCase())), (String)((String)entry.getValue()));
            }
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "HEAD", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateMetadata() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse().addHeader("X-Container-Meta-ApiName", (Object)"swift").addHeader("X-Container-Meta-ApiVersion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").updateMetadata("myContainer", metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest replaceRequest = server.takeRequest();
            Assert.assertEquals((String)replaceRequest.getRequestLine(), (String)"POST /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer HTTP/1.1");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)replaceRequest.getHeader("X-Container-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMetadata() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse()));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").deleteMetadata("myContainer", metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"POST /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer HTTP/1.1");
            for (String key : metadata.keySet()) {
                Assert.assertEquals((String)deleteRequest.getHeader("X-Remove-Container-Meta-" + key.toLowerCase()), (String)"ignored");
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteIfEmpty() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").deleteIfEmpty("myContainer"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"DELETE /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlreadyDeleted() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getContainerApi("DFW").deleteIfEmpty("myContainer"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"DELETE /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWhenNotEmpty() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(409)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertFalse((boolean)api.getContainerApi("DFW").deleteIfEmpty("myContainer"));
        }
        finally {
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"DELETE /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer HTTP/1.1");
            server.shutdown();
        }
    }

    static MockResponse containerResponse() {
        return new MockResponse().addHeader("X-Container-Object-Count", (Object)"42").addHeader("X-Container-Bytes-Used", (Object)"323479");
    }
}

