/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Segment;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.internal.BaseSwiftApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="StaticLargeObjectApiLiveTest")
public class StaticLargeObjectApiLiveTest
extends BaseSwiftApiLiveTest<SwiftApi> {
    private String name = ((Object)((Object)this)).getClass().getSimpleName();
    private String containerName = ((Object)((Object)this)).getClass().getSimpleName() + "Container";
    private byte[] megOf1s;
    private byte[] megOf2s;

    public void testNotPresentWhenDeleting() throws Exception {
        for (String regionId : this.regions) {
            ((SwiftApi)this.api).getStaticLargeObjectApi(regionId, this.containerName).delete(UUID.randomUUID().toString());
        }
    }

    public void testReplaceManifest() throws Exception {
        for (String regionId : this.regions) {
            ObjectApi objectApi = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName);
            String etag1s = objectApi.put(this.name + "/1", (Payload)Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])this.megOf1s)));
            this.assertMegabyteAndETagMatches(regionId, this.name + "/1", etag1s);
            String etag2s = objectApi.put(this.name + "/2", (Payload)Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])this.megOf2s)));
            this.assertMegabyteAndETagMatches(regionId, this.name + "/2", etag2s);
            ImmutableList segments = ImmutableList.builder().add((Object)Segment.builder().path(String.format("%s/%s/1", this.containerName, this.name)).etag(etag1s).sizeBytes(0x100000L).build()).add((Object)Segment.builder().path(String.format("%s/%s/2", this.containerName, this.name)).etag(etag2s).sizeBytes(0x100000L).build()).build();
            String etagOfEtags = ((SwiftApi)this.api).getStaticLargeObjectApi(regionId, this.containerName).replaceManifest(this.name, (List)segments, (Map)ImmutableMap.of((Object)"myfoo", (Object)"Bar"));
            Assert.assertNotNull((Object)etagOfEtags);
            SwiftObject bigObject = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(this.name);
            Assert.assertEquals((String)bigObject.getETag(), (String)etagOfEtags);
            Assert.assertEquals((Object)bigObject.getPayload().getContentMetadata().getContentLength(), (Object)0x200000L);
            Assert.assertEquals((Map)bigObject.getMetadata(), (Map)ImmutableMap.of((Object)"myfoo", (Object)"Bar"));
            Assert.assertEquals((long)((SwiftApi)this.api).getContainerApi(regionId).get(this.containerName).getObjectCount(), (long)3L);
        }
    }

    @Test(dependsOnMethods={"testReplaceManifest"})
    public void testDelete() throws Exception {
        for (String regionId : this.regions) {
            ((SwiftApi)this.api).getStaticLargeObjectApi(regionId, this.containerName).delete(this.name);
            Assert.assertEquals((long)((SwiftApi)this.api).getContainerApi(regionId).get(this.containerName).getObjectCount(), (long)0L);
        }
    }

    protected void assertMegabyteAndETagMatches(String regionId, String name, String etag1s) {
        SwiftObject object1s = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(name);
        Assert.assertEquals((String)object1s.getETag(), (String)etag1s);
        Assert.assertEquals((Object)object1s.getPayload().getContentMetadata().getContentLength(), (Object)0x100000L);
    }

    @Override
    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        for (String regionId : this.regions) {
            boolean created = ((SwiftApi)this.api).getContainerApi(regionId).create(this.containerName);
            if (created) continue;
            this.deleteAllObjectsInContainer(regionId, this.containerName);
        }
        this.megOf1s = new byte[0x100000];
        this.megOf2s = new byte[0x100000];
        Arrays.fill(this.megOf1s, (byte)1);
        Arrays.fill(this.megOf2s, (byte)2);
    }

    @AfterClass(groups={"live"})
    public void tearDown() {
        for (String regionId : this.regions) {
            this.deleteAllObjectsInContainer(regionId, this.containerName);
            ((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.containerName);
        }
        super.tearDown();
    }
}

