/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.List;
import java.util.Map;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Segment;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="StaticLargeObjectApiMockTest")
public class StaticLargeObjectApiMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplaceManifest() throws Exception {
        MockWebServer server = StaticLargeObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().addHeader("ETag", (Object)"\"abcd\"")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertEquals((String)api.getStaticLargeObjectApi("DFW", "myContainer").replaceManifest("myObject", (List)ImmutableList.builder().add((Object)Segment.builder().path("/mycontainer/objseg1").etag("0228c7926b8b642dfb29554cd1f00963").sizeBytes(0x166666L).build()).add((Object)Segment.builder().path("/mycontainer/pseudodir/seg-obj2").etag("5bfc9ea51a00b790717eeb934fb77b9b").sizeBytes(0x180000L).build()).add((Object)Segment.builder().path("/other-container/seg-final").etag("b9c3da507d2557c1ddc51f27c54bae51").sizeBytes(256L).build()).build(), (Map)ImmutableMap.of((Object)"MyFoo", (Object)"Bar")), (String)"abcd");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest replaceRequest = server.takeRequest();
            this.assertRequest(replaceRequest, "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject?multipart-manifest=put");
            Assert.assertEquals((String)replaceRequest.getHeader("X-Object-Meta-myfoo"), (String)"Bar");
            Assert.assertEquals((String)new String(replaceRequest.getBody()), (String)"[{\"path\":\"/mycontainer/objseg1\",\"etag\":\"0228c7926b8b642dfb29554cd1f00963\",\"size_bytes\":1468006},{\"path\":\"/mycontainer/pseudodir/seg-obj2\",\"etag\":\"5bfc9ea51a00b790717eeb934fb77b9b\",\"size_bytes\":1572864},{\"path\":\"/other-container/seg-final\",\"etag\":\"b9c3da507d2557c1ddc51f27c54bae51\",\"size_bytes\":256}]");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        MockWebServer server = StaticLargeObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            api.getStaticLargeObjectApi("DFW", "myContainer").delete("myObject");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "DELETE", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject?multipart-manifest=delete");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlreadyDeleted() throws Exception {
        MockWebServer server = StaticLargeObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            api.getStaticLargeObjectApi("DFW", "myContainer").delete("myObject");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "DELETE", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject?multipart-manifest=delete");
        }
        finally {
            server.shutdown();
        }
    }
}

