/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.swift.v1.domain.BulkDeleteResponse;
import org.jclouds.openstack.swift.v1.domain.DeleteStaticLargeObjectResponse;
import org.jclouds.openstack.swift.v1.domain.ExtractArchiveResponse;

public class SwiftTypeAdapters
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Provides
    public Map<Type, Object> provideCustomAdapterBindings() {
        return ImmutableMap.builder().put(ExtractArchiveResponse.class, (Object)new ExtractArchiveResponseAdapter()).put(BulkDeleteResponse.class, (Object)new BulkDeleteResponseAdapter()).put(DeleteStaticLargeObjectResponse.class, (Object)new StaticLargeObjectResponseAdapter()).build();
    }

    static void readErrors(JsonReader reader, ImmutableMap.Builder<String, String> errors) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginArray();
            String decodedPath = URI.create(reader.nextString()).getPath();
            errors.put((Object)decodedPath, (Object)reader.nextString());
            reader.endArray();
        }
        reader.endArray();
    }

    static final class StaticLargeObjectResponseAdapter
    extends TypeAdapter<DeleteStaticLargeObjectResponse> {
        StaticLargeObjectResponseAdapter() {
        }

        public DeleteStaticLargeObjectResponse read(JsonReader reader) throws IOException {
            String status = "";
            int deleted = 0;
            int notFound = 0;
            ImmutableMap.Builder errors = ImmutableMap.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals("Response Status")) {
                    status = reader.nextString();
                    continue;
                }
                if (key.equals("Number Deleted")) {
                    deleted = reader.nextInt();
                    continue;
                }
                if (key.equals("Number Not Found")) {
                    notFound = reader.nextInt();
                    continue;
                }
                if (key.equals("Errors")) {
                    SwiftTypeAdapters.readErrors(reader, (ImmutableMap.Builder<String, String>)errors);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return DeleteStaticLargeObjectResponse.create(status, deleted, notFound, (Map<String, String>)errors.build());
        }

        public void write(JsonWriter arg0, DeleteStaticLargeObjectResponse arg1) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class BulkDeleteResponseAdapter
    extends TypeAdapter<BulkDeleteResponse> {
        BulkDeleteResponseAdapter() {
        }

        public BulkDeleteResponse read(JsonReader reader) throws IOException {
            int deleted = 0;
            int notFound = 0;
            ImmutableMap.Builder errors = ImmutableMap.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals("Number Deleted")) {
                    deleted = reader.nextInt();
                    continue;
                }
                if (key.equals("Number Not Found")) {
                    notFound = reader.nextInt();
                    continue;
                }
                if (key.equals("Errors")) {
                    SwiftTypeAdapters.readErrors(reader, (ImmutableMap.Builder<String, String>)errors);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return BulkDeleteResponse.create(deleted, notFound, (Map<String, String>)errors.build());
        }

        public void write(JsonWriter arg0, BulkDeleteResponse arg1) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class ExtractArchiveResponseAdapter
    extends TypeAdapter<ExtractArchiveResponse> {
        ExtractArchiveResponseAdapter() {
        }

        public ExtractArchiveResponse read(JsonReader reader) throws IOException {
            int created = 0;
            ImmutableMap.Builder errors = ImmutableMap.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals("Number Files Created")) {
                    created = reader.nextInt();
                    continue;
                }
                if (key.equals("Errors")) {
                    SwiftTypeAdapters.readErrors(reader, (ImmutableMap.Builder<String, String>)errors);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return ExtractArchiveResponse.create(created, (Map<String, String>)errors.build());
        }

        public void write(JsonWriter arg0, ExtractArchiveResponse arg1) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

