/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.net.UrlEscapers;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.v1.binders.SetPayload;
import org.jclouds.openstack.swift.v1.domain.BulkDeleteResponse;
import org.jclouds.openstack.swift.v1.domain.ExtractArchiveResponse;
import org.jclouds.rest.Binder;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface BulkApi {
    @Named(value="bulk:extractArchive")
    @PUT
    @Path(value="/{path}")
    public ExtractArchiveResponse extractArchive(@PathParam(value="path") String var1, @BinderParam(value=SetPayload.class) Payload var2, @QueryParam(value="extract-archive") String var3);

    @Named(value="bulk:delete")
    @DELETE
    @QueryParams(keys={"bulk-delete"})
    public BulkDeleteResponse bulkDelete(@BinderParam(value=UrlEncodeAndJoinOnNewline.class) Iterable<String> var1);

    public static class UrlEncodeAndJoinOnNewline
    implements Binder {
        public <R extends HttpRequest> R bindToRequest(R request, Object input) {
            String encodedAndNewlineDelimited = Joiner.on((char)'\n').join(Iterables.transform((Iterable)((Iterable)Iterable.class.cast(input)), (Function)UrlEscapers.urlFragmentEscaper().asFunction()));
            StringPayload payload = Payloads.newStringPayload((String)encodedAndNewlineDelimited);
            payload.getContentMetadata().setContentType("text/plain");
            return (R)((HttpRequest.Builder)request.toBuilder().payload((Payload)payload)).build();
        }
    }
}

