/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SessionPersistence;
import org.jclouds.rest.InvocationContext;

public class ParseSessionPersistence
implements Function<HttpResponse, SessionPersistence>,
InvocationContext<ParseSessionPersistence> {
    private final ParseJson<Map<String, Map<String, SessionPersistence>>> json;

    @Inject
    ParseSessionPersistence(ParseJson<Map<String, Map<String, SessionPersistence>>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public SessionPersistence apply(HttpResponse response) {
        Map map = (Map)this.json.apply(response);
        if (map == null || map.isEmpty()) {
            throw new HttpResponseException("Unexpected connection logging format returned.", null, response);
        }
        if (((Map)Iterables.get(map.values(), (int)0)).isEmpty()) {
            return null;
        }
        return (SessionPersistence)((Object)Iterables.get(((Map)Iterables.get(map.values(), (int)0)).values(), (int)0));
    }

    public ParseSessionPersistence setContext(HttpRequest request) {
        return this;
    }
}

