/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.DeleteResult;
import org.jclouds.s3.domain.ListMultipartUploadResponse;
import org.jclouds.s3.domain.ListMultipartUploadsResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.util.Strings2;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"})
public class S3ClientLiveTest
extends BaseBlobStoreIntegrationTest {
    public static final String TEST_ACL_ID = "1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c";
    public static final String TEST_ACL_EMAIL = "james@misterm.org";
    public static final String DEFAULT_OWNER_ID = "abc123";
    private static final ByteSource oneHundredOneConstitutions = TestUtils.randomByteSource().slice(0L, 0x500001L);
    protected String sessionToken;
    String sourceKey = "apples";
    String destinationKey = "pears";

    public S3ClientLiveTest() {
        this.provider = "s3";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        this.sessionToken = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".sessionToken");
        return overrides;
    }

    protected ContextBuilder newBuilder() {
        ContextBuilder builder = super.newBuilder();
        if (this.sessionToken != null) {
            builder.credentialsSupplier((Supplier)new Supplier<Credentials>(){

                public Credentials get() {
                    return SessionCredentials.builder().identity(S3ClientLiveTest.this.identity).credential(S3ClientLiveTest.this.credential).sessionToken(S3ClientLiveTest.this.sessionToken).build();
                }
            });
        }
        return builder;
    }

    public S3Client getApi() {
        return (S3Client)((BlobStoreContext)this.view).unwrapApi(S3Client.class);
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyNotFound() throws Exception {
        assert (this.getApi().deleteBucketIfEmpty("dbienf"));
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyButHasContents() throws Exception {
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, "test");
            assert (!this.getApi().deleteBucketIfEmpty(containerName));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected URL getObjectURL(String containerName, String key) throws Exception {
        URL url = new URL(String.format("http://%s.%s/%s", containerName, URI.create(this.endpoint).getHost(), key));
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"fails-on-s3proxy"})
    public void testPutCannedAccessPolicyPublic() throws Exception {
        String containerName = this.getContainerName();
        try {
            String key = "hello";
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey(key);
            object.setPayload(TEST_STRING);
            this.getApi().putObject(containerName, object, new PutObjectOptions[]{PutObjectOptions.Builder.withAcl((CannedAccessPolicy)CannedAccessPolicy.PUBLIC_READ)});
            URL url = this.getObjectURL(containerName, key);
            Strings2.toStringAndClose((InputStream)url.openStream());
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"fails-on-s3proxy"})
    public void testCopyCannedAccessPolicyPublic() throws Exception {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, this.sourceKey);
            this.validateContent(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.overrideAcl((CannedAccessPolicy)CannedAccessPolicy.PUBLIC_READ)});
            this.validateContent(destinationContainer, this.destinationKey);
            URL url = this.getObjectURL(destinationContainer, this.destinationKey);
            Strings2.toStringAndClose((InputStream)url.openStream());
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"fails-on-s3proxy"})
    public void testPublicWriteOnObject() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String publicReadWriteObjectKey = "public-read-write-acl";
        final String containerName = this.getContainerName();
        try {
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey("public-read-write-acl");
            object.setPayload("");
            this.getApi().putObject(containerName, object, new PutObjectOptions[]{new PutObjectOptions().withAcl(CannedAccessPolicy.PUBLIC_READ_WRITE)});
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessControlList acl = S3ClientLiveTest.this.getApi().getObjectACL(containerName, "public-read-write-acl");
                        Assert.assertEquals((int)acl.getGrants().size(), (int)3);
                        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.ALL_USERS).size(), (int)2);
                        Assert.assertNotNull((Object)acl.getOwner());
                        String ownerId = acl.getOwner().getId();
                        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "WRITE"));
                        Assert.assertFalse((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ_ACP"));
                        Assert.assertFalse((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "WRITE_ACP"));
                        Assert.assertFalse((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "FULL_CONTROL"));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"fails-on-s3proxy"})
    public void testUpdateObjectACL() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        try {
            String objectKey = "private-acl";
            this.addBlobToContainer(containerName, objectKey);
            AccessControlList acl = this.getApi().getObjectACL(containerName, objectKey);
            String ownerId = acl.getOwner().getId();
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
            this.addGrantsToACL(acl);
            Assert.assertEquals((int)acl.getGrants().size(), (int)4);
            Assert.assertTrue((boolean)this.getApi().putObjectACL(containerName, objectKey, acl));
            acl = this.getApi().getObjectACL(containerName, objectKey);
            this.checkGrants(acl);
            acl.revokeAllPermissions((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(ownerId));
            if (!ownerId.equals(TEST_ACL_ID)) {
                acl.revokeAllPermissions((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(TEST_ACL_ID));
            }
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
            Assert.assertTrue((boolean)this.getApi().putObjectACL(containerName, objectKey, acl));
            acl = this.getApi().getObjectACL(containerName, objectKey);
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertEquals((int)acl.getPermissions(ownerId).size(), (int)0);
            Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrivateAclIsDefaultForObject() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String privateObjectKey = "private-acl";
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, privateObjectKey);
            AccessControlList acl = this.getApi().getObjectACL(containerName, privateObjectKey);
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertNotNull((Object)acl.getOwner());
            String ownerId = acl.getOwner().getId();
            Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublicReadOnObject() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String publicReadObjectKey = "public-read-acl";
        final String containerName = this.getContainerName();
        try {
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey("public-read-acl");
            object.setPayload("");
            this.getApi().putObject(containerName, object, new PutObjectOptions[]{new PutObjectOptions().withAcl(CannedAccessPolicy.PUBLIC_READ)});
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessControlList acl = S3ClientLiveTest.this.getApi().getObjectACL(containerName, "public-read-acl");
                        Assert.assertEquals((int)acl.getGrants().size(), (int)2);
                        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.ALL_USERS).size(), (int)1);
                        Assert.assertNotNull((Object)acl.getOwner());
                        String ownerId = acl.getOwner().getId();
                        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
                        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected String addBlobToContainer(String sourceContainer, String key) {
        S3Object sourceObject = this.getApi().newS3Object();
        sourceObject.getMetadata().setKey(key);
        sourceObject.getMetadata().getContentMetadata().setContentType("text/xml");
        sourceObject.setPayload(TEST_STRING);
        return this.getApi().putObject(sourceContainer, sourceObject, new PutObjectOptions[0]);
    }

    protected S3Object validateObject(String sourceContainer, String key) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.assertConsistencyAwareContainerSize(sourceContainer, 1);
        S3Object newObject = this.getApi().getObject(sourceContainer, key, new GetOptions[0]);
        assert (newObject != null);
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)newObject.getPayload().openStream()), (String)TEST_STRING);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMetadataWithCacheControlAndContentDisposition() throws Exception {
        String key = "hello";
        S3Object object = this.getApi().newS3Object();
        object.getMetadata().setKey(key);
        object.setPayload(TEST_STRING);
        object.getMetadata().setCacheControl("no-cache");
        object.getMetadata().getContentMetadata().setContentDisposition("attachment; filename=hello.txt");
        String containerName = this.getContainerName();
        try {
            this.getApi().putObject(containerName, object, new PutObjectOptions[0]);
            S3Object newObject = this.validateObject(containerName, key);
            this.assertCacheControl(newObject, "no-cache");
            Assert.assertEquals((String)newObject.getMetadata().getContentMetadata().getContentDisposition(), (String)"attachment; filename=hello.txt");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void assertCacheControl(S3Object newObject, String string) {
        assert (newObject.getMetadata().getCacheControl().indexOf(string) != -1) : newObject.getMetadata().getCacheControl();
    }

    protected void assertContentEncoding(S3Object newObject, String string) {
        assert (newObject.getPayload().getContentMetadata().getContentEncoding().indexOf(string) != -1) : newObject.getPayload().getContentMetadata().getContentEncoding();
        assert (newObject.getMetadata().getContentMetadata().getContentEncoding().indexOf(string) != -1) : newObject.getMetadata().getContentMetadata().getContentEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMetadataContentEncoding() throws Exception {
        String key = "hello";
        S3Object object = this.getApi().newS3Object();
        object.getMetadata().setKey(key);
        object.setPayload(TEST_STRING);
        object.getMetadata().getContentMetadata().setContentEncoding("x-compress");
        String containerName = this.getContainerName();
        try {
            this.getApi().putObject(containerName, object, new PutObjectOptions[0]);
            S3Object newObject = this.validateObject(containerName, key);
            this.assertContentEncoding(newObject, "x-compress");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    public void testCopyObject() throws Exception {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            this.addToContainerAndValidate(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[0]);
            this.validateContent(destinationContainer, this.destinationKey);
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyObjectWithSourceKeyRequiringEncoding() throws Exception {
        String containerName = this.getContainerName();
        String sourceKeyRequiringEncoding = "apples#?:$&'\"<>\u010d\u0950";
        String destinationContainer = this.getContainerName();
        try {
            this.addToContainerAndValidate(containerName, sourceKeyRequiringEncoding);
            this.getApi().copyObject(containerName, sourceKeyRequiringEncoding, destinationContainer, this.destinationKey, new CopyObjectOptions[0]);
            this.validateContent(destinationContainer, this.destinationKey);
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    protected String addToContainerAndValidate(String containerName, String sourceKey) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String etag = this.addBlobToContainer(containerName, sourceKey);
        this.validateContent(containerName, sourceKey);
        return etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfModifiedSince() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            Date before = new Date(System.currentTimeMillis() - 10000L);
            this.addToContainerAndValidate(containerName, this.sourceKey + "mod");
            Date after = new Date(System.currentTimeMillis() + 10000L);
            this.getApi().copyObject(containerName, this.sourceKey + "mod", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceModifiedSince((Date)before)});
            this.validateContent(destinationContainer, this.destinationKey);
            TimeUnit.SECONDS.sleep(20L);
            try {
                this.getApi().copyObject(containerName, this.sourceKey + "mod", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceModifiedSince((Date)after)});
                Assert.fail((String)"should have thrown HttpResponseException");
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfUnmodifiedSince() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            Date before = new Date(System.currentTimeMillis() - 10000L);
            this.addToContainerAndValidate(containerName, this.sourceKey + "un");
            Date after = new Date(System.currentTimeMillis() + 10000L);
            this.getApi().copyObject(containerName, this.sourceKey + "un", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)after)});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey + "un", destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)before)});
                Assert.fail((String)"should have thrown HttpResponseException");
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfMatch() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            String goodETag = this.addToContainerAndValidate(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagMatches((String)goodETag)});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagMatches((String)"setsds")});
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyIfNoneMatch() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            String goodETag = this.addToContainerAndValidate(containerName, this.sourceKey);
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)"asfasdf")});
            this.validateContent(destinationContainer, this.destinationKey);
            try {
                this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)goodETag)});
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyWithMetadata() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        String destinationContainer = this.getContainerName();
        try {
            this.addToContainerAndValidate(containerName, this.sourceKey);
            HashMap metadata = Maps.newHashMap();
            metadata.put("adrian", "cole");
            this.getApi().copyObject(containerName, this.sourceKey, destinationContainer, this.destinationKey, new CopyObjectOptions[]{CopyObjectOptions.Builder.overrideMetadataWith((Map)metadata)});
            this.validateContent(destinationContainer, this.destinationKey);
            ObjectMetadata objectMeta = this.getApi().headObject(destinationContainer, this.destinationKey);
            Assert.assertEquals((Map)objectMeta.getUserMetadata(), (Map)metadata);
        }
        finally {
            this.returnContainer(containerName);
            this.returnContainer(destinationContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnusualKeyCharacters() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        try {
            String dirName = "a%2Fb&xxx#?:$'\\\"<>\u010d\u0950";
            String fileName = "foo%3Abar.xml";
            this.addToContainerAndValidate(containerName, dirName + '/' + fileName);
            PageSet list = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.prefix((String)(dirName + "/")));
            Assert.assertEquals((int)list.size(), (int)1);
            StorageMetadata md = (StorageMetadata)list.iterator().next();
            Assert.assertEquals((String)md.getName(), (String)(dirName + '/' + fileName));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartSynchronously() throws InterruptedException, IOException {
        HashCode oneHundredOneConstitutionsMD5 = oneHundredOneConstitutions.hash(Hashing.md5());
        String containerName = this.getContainerName();
        S3Object object = null;
        try {
            String key = "constitution.txt";
            String uploadId = this.getApi().initiateMultipartUpload(containerName, ObjectMetadataBuilder.create().key(key).contentMD5(oneHundredOneConstitutionsMD5.asBytes()).build(), new PutObjectOptions[0]);
            Assertions.assertThat((Map)this.getApi().listMultipartPartsFull(containerName, key, uploadId)).isEmpty();
            byte[] buffer = oneHundredOneConstitutions.read();
            Assert.assertEquals((long)oneHundredOneConstitutions.size(), (long)buffer.length);
            ByteArrayPayload part1 = Payloads.newByteArrayPayload((byte[])buffer);
            part1.getContentMetadata().setContentLength(Long.valueOf(buffer.length));
            part1.getContentMetadata().setContentMD5(oneHundredOneConstitutionsMD5);
            String eTagOf1 = null;
            try {
                eTagOf1 = this.getApi().uploadPart(containerName, key, 1, uploadId, (Payload)part1);
            }
            catch (KeyNotFoundException e) {
                eTagOf1 = this.getApi().uploadPart(containerName, key, 1, uploadId, (Payload)part1);
            }
            Map map = this.getApi().listMultipartPartsFull(containerName, key, uploadId);
            Assertions.assertThat((Map)map).containsOnlyKeys((Object[])new Integer[]{1});
            Assertions.assertThat((String)((ListMultipartUploadResponse)map.get(1)).eTag()).isEqualTo(eTagOf1);
            this.getApi().completeMultipartUpload(containerName, key, uploadId, (Map)ImmutableMap.of((Object)1, (Object)eTagOf1));
            object = this.getApi().getObject(containerName, key, new GetOptions[0]);
            Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)object.getPayload().openStream()), (byte[])buffer);
        }
        finally {
            if (object != null) {
                object.getPayload().close();
            }
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartCopy() throws Exception {
        String containerName = this.getContainerName();
        try {
            String fromObject = "fromObject";
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey(fromObject);
            object.setPayload(oneHundredOneConstitutions);
            object.getMetadata().getContentMetadata().setContentLength(Long.valueOf(oneHundredOneConstitutions.size()));
            this.getApi().putObject(containerName, object, new PutObjectOptions[0]);
            String toObject = "toObject";
            String uploadId = this.getApi().initiateMultipartUpload(containerName, ObjectMetadataBuilder.create().key(toObject).build(), new PutObjectOptions[0]);
            String eTagOf1 = this.getApi().uploadPartCopy(containerName, toObject, 1, uploadId, containerName, fromObject, 1L, oneHundredOneConstitutions.size() - 1L);
            this.getApi().completeMultipartUpload(containerName, toObject, uploadId, (Map)ImmutableMap.of((Object)1, (Object)eTagOf1));
            object = this.getApi().getObject(containerName, toObject, new GetOptions[0]);
            Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)object.getPayload().openStream()), (byte[])oneHundredOneConstitutions.slice(1L, oneHundredOneConstitutions.size() - 1L).read());
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testListMultipartUploads() throws Exception {
        String containerName;
        block3: {
            containerName = this.getContainerName();
            String key = "testListMultipartUploads";
            String uploadId = null;
            try {
                ListMultipartUploadsResponse response = this.getApi().listMultipartUploads(containerName, null, null, null, null, null);
                Assertions.assertThat((String)response.bucket()).isEqualTo(containerName);
                Assertions.assertThat((boolean)response.isTruncated()).isFalse();
                Assertions.assertThat((List)response.uploads()).isEmpty();
                uploadId = this.getApi().initiateMultipartUpload(containerName, ObjectMetadataBuilder.create().key(key).build(), new PutObjectOptions[0]);
                response = this.getApi().listMultipartUploads(containerName, null, null, null, null, null);
                Assertions.assertThat((String)response.bucket()).isEqualTo(containerName);
                Assertions.assertThat((boolean)response.isTruncated()).isFalse();
                Assertions.assertThat((List)response.uploads()).hasSize(1);
                ListMultipartUploadsResponse.Upload upload = (ListMultipartUploadsResponse.Upload)response.uploads().get(0);
                Assertions.assertThat((String)upload.key()).isEqualTo(key);
                Assertions.assertThat((String)upload.uploadId()).isEqualTo(uploadId);
                Assertions.assertThat((Comparable)upload.storageClass()).isEqualTo((Object)ObjectMetadata.StorageClass.STANDARD);
                if (uploadId == null) break block3;
            }
            catch (Throwable throwable) {
                if (uploadId != null) {
                    this.getApi().abortMultipartUpload(containerName, key, uploadId);
                }
                this.returnContainer(containerName);
                throw throwable;
            }
            this.getApi().abortMultipartUpload(containerName, key, uploadId);
        }
        this.returnContainer(containerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMultipleObjects() throws InterruptedException {
        String container = this.getContainerName();
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < 5; ++i) {
                String key = UUID.randomUUID().toString();
                Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).payload("").build();
                ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
                builder.add((Object)key);
            }
            ImmutableSet keys = builder.build();
            DeleteResult result = this.getApi().deleteObjects(container, (Iterable)keys);
            Assert.assertTrue((boolean)result.getDeleted().containsAll((Collection<?>)keys));
            Assert.assertEquals((int)result.getErrors().size(), (int)0);
            for (String key : keys) {
                this.assertConsistencyAwareBlobDoesntExist(container, key);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void checkGrants(AccessControlList acl) {
        String ownerId = acl.getOwner().getId();
        Assert.assertEquals((int)acl.getGrants().size(), (int)4, (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "WRITE_ACP"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(TEST_ACL_ID, "READ_ACP"), (String)acl.toString());
    }

    private void addGrantsToACL(AccessControlList acl) {
        String ownerId = acl.getOwner().getId();
        acl.addPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ");
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee(TEST_ACL_EMAIL), "READ_ACP");
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(ownerId), "WRITE_ACP");
    }

    public void testUpdateBucketCannedACL() throws Exception {
        String containerName = this.getContainerName();
        try {
            this.getApi().updateBucketCannedACL(containerName, CannedAccessPolicy.PUBLIC_READ);
            AccessControlList acl = this.getApi().getBucketACL(containerName);
            Assertions.assertThat((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")).isTrue();
            this.getApi().updateBucketCannedACL(containerName, CannedAccessPolicy.PRIVATE);
            acl = this.getApi().getBucketACL(containerName);
            Assertions.assertThat((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")).isFalse();
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateObjectCannedACL() throws Exception {
        String containerName = this.getContainerName();
        try {
            String key = "testUpdateObjectCannedACL";
            S3Object object = this.getApi().newS3Object();
            object.getMetadata().setKey(key);
            object.setPayload(TEST_STRING);
            this.getApi().putObject(containerName, object, new PutObjectOptions[0]);
            this.getApi().updateObjectCannedACL(containerName, key, CannedAccessPolicy.PUBLIC_READ);
            AccessControlList acl = this.getApi().getObjectACL(containerName, key);
            Assertions.assertThat((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")).isTrue();
            this.getApi().updateObjectCannedACL(containerName, key, CannedAccessPolicy.PRIVATE);
            acl = this.getApi().getObjectACL(containerName, key);
            Assertions.assertThat((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")).isFalse();
            object = this.getApi().getObject(containerName, key, new GetOptions[0]);
            Assertions.assertThat((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream())).isEqualTo(TEST_STRING);
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

