/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.s3.binders.BindBucketLoggingToXmlPayload;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindBucketLoggingToXmlPayloadTest")
public class BindBucketLoggingToXmlPayloadTest
extends BaseHandlerTest {
    public void testApplyInputStream() throws IOException {
        BucketLogging bucketLogging = new BucketLogging("mylogs", "access_log-", (Iterable)ImmutableSet.of((Object)new AccessControlList.Grant((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("adrian@jclouds.org"), "FULL_CONTROL")));
        String expected = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/bucket_logging.xml"));
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://test").build();
        BindBucketLoggingToXmlPayload binder = new BindBucketLoggingToXmlPayload();
        binder.bindToRequest(request, (Object)bucketLogging);
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"text/xml");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)expected);
    }
}

