/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.fallbacks;

import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.util.List;
import org.easymock.EasyMock;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.fallbacks.FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists;
import org.jclouds.s3.options.PutBucketOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExistsTest")
public class FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExistsTest {
    GeneratedHttpRequest putBucket;

    @BeforeClass
    void setUp() throws SecurityException, NoSuchMethodException {
        this.putBucket = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("PUT")).endpoint("https://adriancole-blobstore113.s3.amazonaws.com/")).invocation(Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"putBucketInRegion", (Class[])new Class[]{String.class, String.class, PutBucketOptions[].class}), (List)Lists.newArrayList((Object[])new Object[]{null, "bucket"}))).build();
    }

    @Test
    void testBucketAlreadyOwnedByYouIsOk() throws Exception {
        S3Client client = (S3Client)EasyMock.createMock(S3Client.class);
        EasyMock.replay((Object[])new Object[]{client});
        Exception e = this.getErrorWithCode("BucketAlreadyOwnedByYou");
        Assert.assertFalse((boolean)new FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(client).setContext((HttpRequest)this.putBucket).createOrPropagate((Throwable)e));
        EasyMock.verify((Object[])new Object[]{client});
    }

    @Test
    void testOperationAbortedIsOkWhenBucketExists() throws Exception {
        S3Client client = (S3Client)EasyMock.createMock(S3Client.class);
        EasyMock.expect((Object)client.bucketExists("bucket")).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{client});
        Exception e = this.getErrorWithCode("OperationAborted");
        Assert.assertFalse((boolean)new FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(client).setContext((HttpRequest)this.putBucket).createOrPropagate((Throwable)e));
        EasyMock.verify((Object[])new Object[]{client});
    }

    @Test(expectedExceptions={Exception.class})
    void testOperationAbortedNotOkWhenBucketDoesntExist() throws Exception {
        S3Client client = (S3Client)EasyMock.createMock(S3Client.class);
        EasyMock.expect((Object)client.bucketExists("bucket")).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{client});
        Exception e = this.getErrorWithCode("OperationAborted");
        new FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(client).setContext((HttpRequest)this.putBucket).createOrPropagate((Throwable)e);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    void testIllegalStateIsNotOk() throws Exception {
        S3Client client = (S3Client)EasyMock.createMock(S3Client.class);
        EasyMock.replay((Object[])new Object[]{client});
        IllegalStateException e = new IllegalStateException();
        new FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(client).createOrPropagate((Throwable)e);
    }

    @Test(expectedExceptions={AWSResponseException.class})
    void testBlahIsNotOk() throws Exception {
        S3Client client = (S3Client)EasyMock.createMock(S3Client.class);
        EasyMock.replay((Object[])new Object[]{client});
        Exception e = this.getErrorWithCode("blah");
        new FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(client).createOrPropagate((Throwable)e);
    }

    private Exception getErrorWithCode(String code) {
        AWSError error = new AWSError();
        error.setCode(code);
        return new AWSResponseException(null, null, null, error);
    }
}

