/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Injector;
import jakarta.inject.Named;
import java.util.Date;
import java.util.List;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3HttpApiModule;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.filters.RequestAuthorizeSignatureV4;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RequestAuthorizeSignatureV4Test")
public class RequestAuthorizeSignatureV4Test {
    private static final String IDENTITY = "AKIAPAEBI3QI4EXAMPLE";
    private static final String CREDENTIAL = "oHkkcPcOjJnoAXpjT8GXdNeBjo6Ru7QeFExAmPlE";
    private static final String TIMESTAMP = "Thu, 03 Feb 2015 07:11:11 GMT";
    private static final String GET_BUCKET_LOCATION_SIGNATURE_RESULT = "AWS4-HMAC-SHA256 Credential=AKIAPAEBI3QI4EXAMPLE/20150203/cn-north-1/s3/aws4_request, SignedHeaders=host;x-amz-content-sha256;x-amz-date, Signature=5634847b3ad6a857887ab0ccff2fcaf3d35ef3dc549a3c27ebc0f584a80494c3";
    private static final String GET_OBJECT_RESULT = "AWS4-HMAC-SHA256 Credential=AKIAPAEBI3QI4EXAMPLE/20150203/cn-north-1/s3/aws4_request, SignedHeaders=host;x-amz-content-sha256;x-amz-date, Signature=fbd1d0f04a72907fb20ecd771644afd62cb689f91d26e9471b7a234531ec4718";
    private static final String GET_OBJECT_ACL_RESULT = "AWS4-HMAC-SHA256 Credential=AKIAPAEBI3QI4EXAMPLE/20150203/cn-north-1/s3/aws4_request, SignedHeaders=host;x-amz-content-sha256;x-amz-date, Signature=52d7f31d249032b59781fe69c8124ff4bf209be3f374b28657a60d906c752381";
    private static final String PUT_OBJECT_CONTENT = "text sign";
    private static final String PUT_OBJECT_RESULT = "AWS4-HMAC-SHA256 Credential=AKIAPAEBI3QI4EXAMPLE/20150203/cn-north-1/s3/aws4_request, SignedHeaders=content-length;content-type;host;x-amz-content-sha256;x-amz-date;x-amz-storage-class, Signature=090f1bb1db984221ae1a20c5d12a82820a0d74b4be85f20daa1431604f41df08";
    private static final String LIST_BUCKET_RESULT = "AWS4-HMAC-SHA256 Credential=AKIAPAEBI3QI4EXAMPLE/20150203/cn-north-1/s3/aws4_request, SignedHeaders=host;x-amz-content-sha256;x-amz-date, Signature=6cc5d0758e2599be7cb172fd57cefab2828201a2b4d372972a83dc304de93958";
    private static final String BUCKET_NAME = "test-bucket";
    private static final String OBJECT_NAME = "ExampleObject.txt";
    Credentials temporaryCredentials = new Credentials.Builder().identity("AKIAPAEBI3QI4EXAMPLE").credential("oHkkcPcOjJnoAXpjT8GXdNeBjo6Ru7QeFExAmPlE").build();

    public static Injector injector(Credentials creds) {
        return ContextBuilder.newBuilder((ApiMetadata)new S3ApiMetadata()).credentialsSupplier(Suppliers.ofInstance((Object)creds)).modules((Iterable)ImmutableList.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule(), (Object)((Object)new TestS3HttpApiModule()))).buildInjector();
    }

    public static RequestAuthorizeSignatureV4 filter(Credentials creds) {
        return (RequestAuthorizeSignatureV4)RequestAuthorizeSignatureV4Test.injector(creds).getInstance(RequestAuthorizeSignatureV4.class);
    }

    @Test
    void testGetBucketLocationSignature() {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"getBucketLocation", (Class[])new Class[]{String.class}), (List)ImmutableList.of((Object)BUCKET_NAME));
        GeneratedHttpRequest getBucketLocation = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).invocation(invocation).endpoint("https://test-bucket.s3.cn-north-1.amazonaws.com.cn/")).addHeader("Host", new String[]{"test-bucket.s3.cn-north-1.amazonaws.com.cn"})).addQueryParam("location", new String[]{""})).build();
        HttpRequest filtered = RequestAuthorizeSignatureV4Test.filter(this.temporaryCredentials).filter((HttpRequest)getBucketLocation);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)GET_BUCKET_LOCATION_SIGNATURE_RESULT);
    }

    @Test
    void testGetObjectSignature() {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"getObject", (Class[])new Class[]{String.class, String.class, GetOptions[].class}), (List)ImmutableList.of((Object)BUCKET_NAME, (Object)OBJECT_NAME, (Object)new GetOptions[0]));
        GeneratedHttpRequest getObject = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).invocation(invocation).endpoint("https://test-bucket.s3.cn-north-1.amazonaws.com.cn/ExampleObject.txt")).addHeader("Host", new String[]{"test-bucket.s3.cn-north-1.amazonaws.com.cn"})).build();
        HttpRequest filtered = RequestAuthorizeSignatureV4Test.filter(this.temporaryCredentials).filter((HttpRequest)getObject);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)GET_OBJECT_RESULT);
    }

    @Test
    void testGetObjectACLSignature() {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"getObjectACL", (Class[])new Class[]{String.class, String.class}), (List)ImmutableList.of((Object)BUCKET_NAME));
        GeneratedHttpRequest getObjectACL = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).invocation(invocation).endpoint("https://test-bucket.s3.cn-north-1.amazonaws.com.cn/ExampleObject.txt")).addHeader("Host", new String[]{"test-bucket.s3.cn-north-1.amazonaws.com.cn"})).addQueryParam("acl", new String[]{""})).build();
        HttpRequest filtered = RequestAuthorizeSignatureV4Test.filter(this.temporaryCredentials).filter((HttpRequest)getObjectACL);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)GET_OBJECT_ACL_RESULT);
    }

    @Test
    void testPutObjectSignature() {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class}), (List)ImmutableList.of((Object)BUCKET_NAME));
        StringPayload payload = Payloads.newStringPayload((String)PUT_OBJECT_CONTENT);
        payload.getContentMetadata().setContentType("text/plain");
        GeneratedHttpRequest putObject = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("PUT")).invocation(invocation).endpoint("https://test-bucket.s3.cn-north-1.amazonaws.com.cn/ExampleObject.txt")).addHeader("Host", new String[]{"test-bucket.s3.cn-north-1.amazonaws.com.cn"})).addHeader("x-amz-storage-class", new String[]{"REDUCED_REDUNDANCY"})).payload((Payload)payload)).build();
        HttpRequest filtered = RequestAuthorizeSignatureV4Test.filter(this.temporaryCredentials).filter((HttpRequest)putObject);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)PUT_OBJECT_RESULT);
    }

    @Test
    void testListBucketFunnyCharactersSignature() {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"listBucket", (Class[])new Class[]{String.class, ListBucketOptions[].class}), (List)ImmutableList.of((Object)BUCKET_NAME, (Object)new ListBucketOptions[0]));
        GeneratedHttpRequest getObject = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).invocation(invocation).endpoint("https://test-bucket.s3.cn-north-1.amazonaws.com.cn/?delimiter=/&prefix=foo%252Fbar")).addHeader("Host", new String[]{"test-bucket.s3.cn-north-1.amazonaws.com.cn"})).build();
        HttpRequest filtered = RequestAuthorizeSignatureV4Test.filter(this.temporaryCredentials).filter((HttpRequest)getObject);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)LIST_BUCKET_RESULT);
    }

    @ConfiguresHttpApi
    private static final class TestS3HttpApiModule
    extends S3HttpApiModule<S3Client> {
        private TestS3HttpApiModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return RequestAuthorizeSignatureV4Test.TIMESTAMP;
        }

        protected Supplier<Date> provideTimeStampCacheDate(@Named(value="jclouds.session-interval") long seconds, @TimeStamp Supplier<String> timestamp, DateService dateService) {
            return Suppliers.ofInstance((Object)dateService.rfc822DateParse(RequestAuthorizeSignatureV4Test.TIMESTAMP));
        }
    }
}

