/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Injector;
import java.util.List;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.date.TimeStamp;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3HttpApiModule;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RequestAuthorizeSignatureWithSessionCredentialsTest")
public class RequestAuthorizeSignatureWithSessionCredentialsTest {
    SessionCredentials temporaryCredentials = SessionCredentials.builder().accessKeyId("AKIAIOSFODNN7EXAMPLE").secretAccessKey("wJalrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY").sessionToken("AQoEXAMPLEH4aoAH0gNCAPyJxz4BlCFFxWNE1OPTgk5TthT").expiration(new SimpleDateFormatDateService().iso8601DateParse("2011-07-11T19:55:29.611Z")).build();
    Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"bucketExists", (Class[])new Class[]{String.class}), (List)ImmutableList.of((Object)"foo"));
    HttpRequest bucketFooExists = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).invocation(this.invocation).endpoint("https://s3.amazonaws.com/foo?max-keys=0")).build();

    public static Injector injector(Credentials creds) {
        return ContextBuilder.newBuilder((String)"s3").credentialsSupplier(Suppliers.ofInstance((Object)creds)).modules((Iterable)ImmutableList.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule(), (Object)((Object)new TestS3HttpApiModule()))).buildInjector();
    }

    public static RequestAuthorizeSignature filter(Credentials creds) {
        return (RequestAuthorizeSignature)RequestAuthorizeSignatureWithSessionCredentialsTest.injector(creds).getInstance(RequestAuthorizeSignature.class);
    }

    @Test
    void testAddsSecurityToken() {
        HttpRequest filtered = RequestAuthorizeSignatureWithSessionCredentialsTest.filter((Credentials)this.temporaryCredentials).filter(this.bucketFooExists);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)"AWS AKIAIOSFODNN7EXAMPLE:sbAAy3Gh/sD1zwO7Ut75YJFCs4U=");
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("x-amz-security-token"), (String)this.temporaryCredentials.getSessionToken());
    }

    @ConfiguresHttpApi
    private static final class TestS3HttpApiModule
    extends S3HttpApiModule<S3Client> {
        private TestS3HttpApiModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "2009-11-08T15:54:08.897Z";
        }
    }
}

