/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.CopyObjectResult;
import org.jclouds.s3.xml.CopyObjectHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CopyObjectHandlerTest")
public class CopyObjectHandlerTest
extends BaseHandlerTest {
    private DateService dateService;
    private final String copyObjectResultWithSecondsDate = "<CopyObjectResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><LastModified>2014-07-23T20:53:17+0000</LastModified><ETag>\"92836a3ea45a6984d1b4d23a747d46bb\"</ETag></CopyObjectResult>";

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/copy_object.xml");
        CopyObjectResult expected = new CopyObjectResult(new SimpleDateFormatDateService().iso8601DateParse("2009-03-19T13:23:27.000Z"), "\"92836a3ea45a6984d1b4d23a747d46bb\"");
        ObjectMetadata result = (ObjectMetadata)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(CopyObjectHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    public void testApplyInputStreamWithSecondsDate() {
        InputStream is = Strings2.toInputStream((String)"<CopyObjectResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><LastModified>2014-07-23T20:53:17+0000</LastModified><ETag>\"92836a3ea45a6984d1b4d23a747d46bb\"</ETag></CopyObjectResult>");
        CopyObjectResult expected = new CopyObjectResult(new SimpleDateFormatDateService().iso8601SecondsDateParse("2014-07-23T20:53:17+0000"), "\"92836a3ea45a6984d1b4d23a747d46bb\"");
        ObjectMetadata result = (ObjectMetadata)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(CopyObjectHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }
}

