/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import org.jclouds.PerformanceTest;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.xml.CopyObjectHandler;
import org.jclouds.s3.xml.ListAllMyBucketsHandler;
import org.jclouds.s3.xml.ListBucketHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

@Test(groups={"performance"}, singleThreaded=true, timeOut=120000L, testName="S3ParserTest")
public class S3ParserTest
extends PerformanceTest {
    Injector injector = null;
    ParseSax.Factory factory;
    public static final String listAllMyBucketsResultOn200 = "<ListAllMyBucketsResult xmlns=\"http://s3.amazonaws.com/doc/callables/\"><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID></Owner><Buckets><Bucket><Name>adrianjbosstest</Name><CreationDate>2009-03-12T02:00:07.000Z</CreationDate></Bucket><Bucket><Name>adrianjbosstest2</Name><CreationDate>2009-03-12T02:00:09.000Z</CreationDate></Bucket></Buckets></ListAllMyBucketsResult>";
    public static final String listAllMyBucketsResultOn200DisplayNameFirst = "<ListAllMyBucketsResult xmlns=\"http://s3.amazonaws.com/doc/callables/\"><Owner><DisplayName>TestName</DisplayName><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID></Owner><Buckets><Bucket><Name>adrianjbosstest</Name><CreationDate>2009-03-12T02:00:07.000Z</CreationDate></Bucket></Buckets></ListAllMyBucketsResult>";
    public static final String listAllMyBucketsResultOn200OwnerLast = "<ListAllMyBucketsResult xmlns=\"http://s3.amazonaws.com/doc/callables/\"><Buckets><Bucket><Name>adrianjbosstest</Name><CreationDate>2009-03-12T02:00:07.000Z</CreationDate></Bucket></Buckets><Owner><DisplayName>TestName</DisplayName><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID></Owner></ListAllMyBucketsResult>";
    public static final String listContainerResult = "<ListContainerHandler xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Name>adrianjbosstest</Name><Prefix></Prefix><Marker></Marker><MaxKeys>1000</MaxKeys><IsTruncated>false</IsTruncated><Contents><Key>3366</Key><LastModified>2009-03-12T02:00:13.000Z</LastModified><ETag>&quot;9d7bb64e8e18ee34eec06dd2cf37b766&quot;</ETag><Size>136</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents></ListContainerHandler>";
    public static final String successfulCopyObject200 = "<CopyObjectResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><LastModified>2009-03-19T13:23:27.000Z</LastModified><ETag>\"92836a3ea45a6984d1b4d23a747d46bb\"</ETag></CopyObjectResult>";

    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    @AfterTest
    protected void tearDownInjector() {
        this.factory = null;
        this.injector = null;
    }

    @Test
    void testParseListAllMyBucketsSerialResponseTime() throws HttpException {
        for (int i = 0; i < LOOP_COUNT; ++i) {
            this.runParseListAllMyBuckets();
        }
    }

    private Set<BucketMetadata> runParseListAllMyBuckets() throws HttpException {
        return (Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListAllMyBucketsHandler.class)).parse(Strings2.toInputStream((String)listAllMyBucketsResultOn200));
    }

    @Test
    void testParseListAllMyBucketsParallelResponseTime() throws InterruptedException, ExecutionException {
        int i;
        ExecutorCompletionService<Set<BucketMetadata>> completer = new ExecutorCompletionService<Set<BucketMetadata>>(this.exec);
        for (i = 0; i < LOOP_COUNT; ++i) {
            completer.submit(new Callable<Set<BucketMetadata>>(){

                @Override
                public Set<BucketMetadata> call() throws IOException, SAXException, HttpException {
                    return S3ParserTest.this.runParseListAllMyBuckets();
                }
            });
        }
        for (i = 0; i < LOOP_COUNT; ++i) {
            assert (completer.take().get() != null);
        }
    }

    @Test
    public void testCanParseListAllMyBuckets() throws HttpException {
        Set<BucketMetadata> s3Buckets = this.runParseListAllMyBuckets();
        BucketMetadata container1 = (BucketMetadata)Iterables.get(s3Buckets, (int)0);
        assert (container1.getName().equals("adrianjbosstest"));
        Date expectedDate1 = new SimpleDateFormatDateService().iso8601DateParse("2009-03-12T02:00:07.000Z");
        Date date1 = container1.getCreationDate();
        assert (date1.equals(expectedDate1));
        BucketMetadata container2 = (BucketMetadata)s3Buckets.toArray()[1];
        assert (container2.getName().equals("adrianjbosstest2"));
        Date expectedDate2 = new SimpleDateFormatDateService().iso8601DateParse("2009-03-12T02:00:09.000Z");
        Date date2 = container2.getCreationDate();
        assert (date2.equals(expectedDate2));
        assert (s3Buckets.size() == 2);
        CanonicalUser owner = new CanonicalUser("e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0");
        assert (container1.getOwner().equals((Object)owner));
        assert (container2.getOwner().equals((Object)owner));
    }

    @Test
    public void testCanParseListAllMyBucketsDisplayNameFirst() throws HttpException {
        Set s3Buckets = (Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListAllMyBucketsHandler.class)).parse(Strings2.toInputStream((String)listAllMyBucketsResultOn200DisplayNameFirst));
        BucketMetadata container = (BucketMetadata)Iterables.get((Iterable)s3Buckets, (int)0);
        assert (container.getName().equals("adrianjbosstest"));
        Date expectedDate1 = new SimpleDateFormatDateService().iso8601DateParse("2009-03-12T02:00:07.000Z");
        Date date = container.getCreationDate();
        assert (date.equals(expectedDate1));
        assert (s3Buckets.size() == 1);
        CanonicalUser owner = new CanonicalUser("e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0", "TestName");
        assert (container.getOwner().equals((Object)owner));
    }

    @Test
    public void testCanParseListAllMyBucketsOwnerLast() throws HttpException {
        Set s3Buckets = (Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListAllMyBucketsHandler.class)).parse(Strings2.toInputStream((String)listAllMyBucketsResultOn200OwnerLast));
        BucketMetadata container = (BucketMetadata)Iterables.get((Iterable)s3Buckets, (int)0);
        assert (container.getName().equals("adrianjbosstest"));
        Date expectedDate = new SimpleDateFormatDateService().iso8601DateParse("2009-03-12T02:00:07.000Z");
        Date date1 = container.getCreationDate();
        assert (date1.equals(expectedDate));
        assert (s3Buckets.size() == 1);
        CanonicalUser owner = new CanonicalUser("e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0", "TestName");
        assert (container.getOwner().equals((Object)owner));
    }

    public void testCanParseListContainerResult() throws HttpException {
        ListBucketResponse container = this.runParseListContainerResult();
        assert (!container.isTruncated());
        assert (container.getName().equals("adrianjbosstest"));
        assert (container.size() == 1);
        ObjectMetadata object = (ObjectMetadata)container.iterator().next();
        assert (object.getKey().equals("3366"));
        Date expected = new SimpleDateFormatDateService().iso8601DateParse("2009-03-12T02:00:13.000Z");
        assert (object.getLastModified().equals(expected)) : String.format("expected %1$s, but got %2$s", expected, object.getLastModified());
        Assert.assertEquals((String)object.getETag(), (String)"\"9d7bb64e8e18ee34eec06dd2cf37b766\"");
        assert (object.getContentMetadata().getContentLength() == 136L);
        CanonicalUser owner = new CanonicalUser("e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0");
        owner.setDisplayName("ferncam");
        assert (object.getOwner().equals((Object)owner));
        assert (object.getStorageClass().equals((Object)ObjectMetadata.StorageClass.STANDARD));
    }

    private ListBucketResponse runParseListContainerResult() throws HttpException {
        return (ListBucketResponse)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListBucketHandler.class)).setContext(HttpRequest.builder().method("GET").endpoint("http://bucket.com").build()).parse(Strings2.toInputStream((String)listContainerResult));
    }

    private ObjectMetadata runParseCopyObjectResult() throws HttpException {
        return (ObjectMetadata)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(CopyObjectHandler.class)).parse(Strings2.toInputStream((String)successfulCopyObject200));
    }

    public void testCanParseCopyObjectResult() throws HttpException {
        ObjectMetadata metadata = this.runParseCopyObjectResult();
        Date expected = new SimpleDateFormatDateService().iso8601DateParse("2009-03-19T13:23:27.000Z");
        Assert.assertEquals((Object)metadata.getLastModified(), (Object)expected);
        Assert.assertEquals((String)metadata.getETag(), (String)"\"92836a3ea45a6984d1b4d23a747d46bb\"");
    }

    @Test
    void testParseListContainerResultSerialResponseTime() throws HttpException {
        for (int i = 0; i < LOOP_COUNT; ++i) {
            this.runParseListContainerResult();
        }
    }

    @Test
    void testParseListContainerResultParallelResponseTime() throws InterruptedException, ExecutionException {
        int i;
        ExecutorCompletionService<ListBucketResponse> completer = new ExecutorCompletionService<ListBucketResponse>(this.exec);
        for (i = 0; i < LOOP_COUNT; ++i) {
            completer.submit(new Callable<ListBucketResponse>(){

                @Override
                public ListBucketResponse call() throws IOException, SAXException, HttpException {
                    return S3ParserTest.this.runParseListContainerResult();
                }
            });
        }
        for (i = 0; i < LOOP_COUNT; ++i) {
            assert (completer.take().get() != null);
        }
    }
}

