/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ListMultipartUploadsResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class ListMultipartUploadsHandler
extends ParseSax.HandlerWithResult<ListMultipartUploadsResponse> {
    private String bucket;
    private String keyMarker;
    private String uploadIdMarker;
    private String nextKeyMarker;
    private String nextUploadIdMarker;
    private int maxUploads;
    private boolean isTruncated;
    private final ImmutableList.Builder<ListMultipartUploadsResponse.Upload> uploads = ImmutableList.builder();
    private String key;
    private String uploadId;
    private String id;
    private String displayName;
    private CanonicalUser initiator;
    private CanonicalUser owner;
    private ObjectMetadata.StorageClass storageClass;
    private Date initiated;
    private final DateService dateParser;
    private final StringBuilder currentText = new StringBuilder();
    private boolean inUpload;
    private boolean inInitiator;
    private boolean inOwner;

    @Inject
    public ListMultipartUploadsHandler(DateService dateParser) {
        this.dateParser = dateParser;
    }

    public ListMultipartUploadsResponse getResult() {
        return ListMultipartUploadsResponse.create(this.bucket, this.keyMarker, this.uploadIdMarker, this.nextKeyMarker, this.nextUploadIdMarker, this.maxUploads, this.isTruncated, (List<ListMultipartUploadsResponse.Upload>)this.uploads.build());
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("Upload")) {
            this.inUpload = true;
        } else if (qName.equals("Initiator")) {
            this.inInitiator = true;
        } else if (qName.equals("Owner")) {
            this.inOwner = true;
        }
        this.currentText.setLength(0);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Bucket")) {
            this.bucket = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("KeyMarker")) {
            this.keyMarker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("UploadIdMarker")) {
            this.uploadIdMarker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("NextKeyMarker")) {
            this.nextKeyMarker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("NextUploadIdMarker")) {
            this.nextUploadIdMarker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("MaxUploads")) {
            this.maxUploads = Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("IsTruncated")) {
            this.isTruncated = Boolean.parseBoolean(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Key")) {
            this.key = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("UploadId")) {
            this.uploadId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("StorageClass")) {
            this.storageClass = ObjectMetadata.StorageClass.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Initiated")) {
            this.initiated = this.dateParser.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Upload")) {
            this.uploads.add((Object)ListMultipartUploadsResponse.Upload.create(this.key, this.uploadId, this.initiator, this.owner, this.storageClass, this.initiated));
            this.key = null;
            this.uploadId = null;
            this.id = null;
            this.displayName = null;
            this.initiator = null;
            this.owner = null;
            this.storageClass = null;
            this.initiated = null;
            this.inUpload = false;
        } else if (qName.equals("Initiator")) {
            this.initiator = new CanonicalUser(this.id, this.displayName);
            this.id = null;
            this.displayName = null;
            this.inInitiator = false;
        } else if (qName.equals("Owner")) {
            this.owner = new CanonicalUser(this.id, this.displayName);
            this.id = null;
            this.displayName = null;
            this.inOwner = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

