/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml.internal;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;

@Singleton
public class BaseRegexQueueHandler {
    protected final Pattern pattern = Pattern.compile("<QueueUrl>(https?://[\\S&&[^<]]+)</QueueUrl>");

    public FluentIterable<URI> parse(String in) {
        ImmutableSet.Builder queues = ImmutableSet.builder();
        Matcher matcher = this.pattern.matcher(in);
        while (matcher.find()) {
            String uriText = matcher.group(1);
            if (Strings.isNullOrEmpty((String)uriText)) continue;
            queues.add((Object)URI.create(uriText));
        }
        return FluentIterable.from((Iterable)queues.build());
    }
}

