/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.xml.ErrorHandler;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class AWSUtils {
    private final RequestSigner signer;
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> errorHandlerProvider;
    private final String requestId;
    private final String requestToken;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    AWSUtils(@Named(value="jclouds.aws.header.tag") String headerTag, RequestSigner signer, ParseSax.Factory factory, Provider<ErrorHandler> errorHandlerProvider) {
        this.signer = signer;
        this.factory = factory;
        this.errorHandlerProvider = errorHandlerProvider;
        this.requestId = String.format("x-%s-request-id", headerTag);
        this.requestToken = String.format("x-%s-id-2", headerTag);
    }

    public AWSError parseAWSErrorFromContent(HttpRequest request, HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        if ("text/plain".equals(response.getPayload().getContentMetadata().getContentType())) {
            return null;
        }
        try {
            AWSError error = (AWSError)this.factory.create((ParseSax.HandlerWithResult)this.errorHandlerProvider.get()).setContext(request).apply(response);
            if (error.getRequestId() == null) {
                error.setRequestId(response.getFirstHeaderOrNull(this.requestId));
            }
            error.setRequestToken(response.getFirstHeaderOrNull(this.requestToken));
            if ("SignatureDoesNotMatch".equals(error.getCode())) {
                error.setStringSigned(this.signer.createStringToSign(request));
                error.setSignature(this.signer.sign(error.getStringSigned()));
            }
            return error;
        }
        catch (RuntimeException e) {
            this.logger.warn((Throwable)e, "error parsing error", new Object[0]);
            return null;
        }
    }

    public static <R extends HttpRequest> R indexStringArrayToFormValuesWithStringFormat(R request, String format, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof String[]), (Object)("this binder is only valid for String[] : " + input.getClass()));
        String[] values = (String[])input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (int i = 0; i < values.length; ++i) {
            builder.put((Object)String.format(format, i + 1), Preconditions.checkNotNull((Object)values[i], (Object)(format.toLowerCase() + "s[" + i + "]")));
        }
        ImmutableMultimap forms = builder.build();
        return (R)(forms.size() == 0 ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }

    public static boolean isRegion(String regionName) {
        return Region.DEFAULT_REGIONS.contains(regionName);
    }

    public static <R extends HttpRequest> R indexIterableToFormValuesWithPrefix(R request, String prefix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable), (Object)("this binder is only valid for Iterable<?>: " + input.getClass()));
        Iterable values = (Iterable)input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        int i = 0;
        for (Object o : values) {
            builder.put((Object)(prefix + "." + (i++ + 1)), Preconditions.checkNotNull((Object)o.toString(), (Object)(prefix.toLowerCase() + "s[" + i + "]")));
        }
        ImmutableMultimap forms = builder.build();
        return (R)(forms.isEmpty() ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }

    public static <R extends HttpRequest> R indexStringArrayToFormValuesWithPrefix(R request, String prefix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof String[]), (Object)("this binder is only valid for String[] : " + input.getClass()));
        String[] values = (String[])input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (int i = 0; i < values.length; ++i) {
            builder.put((Object)(prefix + "." + (i + 1)), Preconditions.checkNotNull((Object)values[i], (Object)(prefix.toLowerCase() + "s[" + i + "]")));
        }
        ImmutableMultimap forms = builder.build();
        return (R)(forms.isEmpty() ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }

    public static <R extends HttpRequest> R indexMapToFormValuesWithPrefix(R request, String prefix, String keySuffix, String valueSuffix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)("this binder is only valid for Map<?,?>: " + input.getClass()));
        Map map = (Map)input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        int i = 1;
        for (Map.Entry e : map.entrySet()) {
            builder.put((Object)(prefix + "." + i + "." + keySuffix), Preconditions.checkNotNull((Object)e.getKey().toString(), (Object)(keySuffix.toLowerCase() + "s[" + i + "]")));
            if (e.getValue() != null) {
                builder.put((Object)(prefix + "." + i + "." + valueSuffix), (Object)e.getValue().toString());
            }
            ++i;
        }
        ImmutableMultimap forms = builder.build();
        return (R)(forms.isEmpty() ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }

    public static <R extends HttpRequest> R indexMultimapToFormValuesWithPrefix(R request, String prefix, String keySuffix, String valueSuffix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Multimap), (Object)("this binder is only valid for Multimap<?,?>: " + input.getClass()));
        Multimap map = (Multimap)input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        int i = 1;
        for (Map.Entry entry : map.asMap().entrySet()) {
            builder.put((Object)(prefix + "." + i + "." + keySuffix), Preconditions.checkNotNull((Object)entry.getKey().toString(), (Object)(keySuffix.toLowerCase() + "s[" + i + "]")));
            int j = 1;
            for (Object v : (Collection)entry.getValue()) {
                builder.put((Object)(prefix + "." + i + "." + valueSuffix + "." + j), (Object)v.toString());
                ++j;
            }
            ++i;
        }
        ImmutableMultimap forms = builder.build();
        return (R)(forms.size() == 0 ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }

    public static <R extends HttpRequest> R indexMapOfIterableToFormValuesWithPrefix(R request, String prefix, String keySuffix, String valueSuffix, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)("this binder is only valid for Map<?,Iterable<?>>: " + input.getClass()));
        Map map = (Map)input;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        int i = 1;
        for (Map.Entry entry : map.entrySet()) {
            builder.put((Object)(prefix + "." + i + "." + keySuffix), Preconditions.checkNotNull((Object)entry.getKey().toString(), (Object)(keySuffix.toLowerCase() + "s[" + i + "]")));
            Iterable iterable = (Iterable)entry.getValue();
            if (!Iterables.isEmpty((Iterable)iterable)) {
                int j = 1;
                for (Object v : iterable) {
                    builder.put((Object)(prefix + "." + i + "." + valueSuffix + "." + j), (Object)v.toString());
                    ++j;
                }
            }
            ++i;
        }
        ImmutableMultimap forms = builder.build();
        return (R)(forms.size() == 0 ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }

    public static String getRegionFromLocationOrNull(Location location) {
        return location.getScope() == LocationScope.ZONE ? location.getParent().getId() : location.getId();
    }

    public static String[] parseHandle(String id) {
        String[] stringArray;
        String[] parts = ((String)Preconditions.checkNotNull((Object)id, (Object)"id")).split("/");
        if (parts.length == 1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = null;
            stringArray = stringArray2;
            stringArray2[1] = id;
        } else {
            stringArray = parts;
        }
        return stringArray;
    }

    public static String findRegionInArgsOrNull(GeneratedHttpRequest gRequest) {
        for (Object arg : gRequest.getInvocation().getArgs()) {
            String regionName;
            if (!(arg instanceof String) || !AWSUtils.isRegion(regionName = (String)arg)) continue;
            return regionName;
        }
        return null;
    }

    @Singleton
    public static class GetRegionFromLocation
    implements Function<Location, String> {
        public String apply(Location location) {
            String region = location.getScope() == LocationScope.REGION ? location.getId() : location.getParent().getId();
            return region;
        }
    }
}

