/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BaseContainerIntegrationTest
extends BaseBlobStoreIntegrationTest {
    @Test(groups={"integration", "live"})
    public void containerDoesntExist() {
        Random random = new Random();
        assert (!((BlobStoreContext)this.view).getBlobStore().containerExists("forgetaboutit" + random.nextInt(Integer.MAX_VALUE)));
        assert (!((BlobStoreContext)this.view).getBlobStore().containerExists("cloudcachestorefunctionalintegrationtest-first" + random.nextInt(Integer.MAX_VALUE)));
    }

    @Test(groups={"integration", "live"})
    public void testPutTwiceIsOkAndDoesntOverwrite() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().createContainerInLocation(null, containerName);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("hello").payload(TEST_STRING).build();
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, blob);
            ((BlobStoreContext)this.view).getBlobStore().createContainerInLocation(null, containerName);
            this.awaitConsistency();
            Assert.assertEquals((long)((BlobStoreContext)this.view).getBlobStore().countBlobs(containerName), (long)1L);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListMarkerAfterLastKey() throws Exception {
        String key = "hello";
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes()).build());
            this.validateContent(containerName, key);
            this.awaitConsistency();
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.afterMarker((String)key));
            Assertions.assertThat((Collection)container).isEmpty();
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListContainerWithZeroMaxResults() throws Exception {
        String key = "hello";
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes()).build());
            this.awaitConsistency();
            this.validateContent(containerName, key);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)0));
            Assertions.assertThat((Collection)container).isEmpty();
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testWithDetails() throws InterruptedException, IOException {
        String key = "hello";
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes()).build());
            this.awaitConsistency();
            this.validateContent(containerName, key);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1).withDetails());
            BlobMetadata metadata = (BlobMetadata)BlobMetadata.class.cast(Iterables.get((Iterable)container, (int)0));
            assert (metadata.getContentMetadata().getContentType().startsWith("text/plain")) : metadata.getContentMetadata().getContentType();
            Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)TEST_STRING.length());
            Assert.assertEquals((String)((String)metadata.getUserMetadata().get("adrian")), (String)"powderpuff");
            this.checkMD5(metadata);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void checkMD5(BlobMetadata metadata) throws IOException {
        Assert.assertEquals((byte[])metadata.getContentMetadata().getContentMD5(), (byte[])Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes());
    }

    @Test(groups={"integration", "live"})
    public void testClearWhenContentsUnderPath() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.add5BlobsUnderPathAnd5UnderRootToContainer(containerName);
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.assertConsistencyAwareContainerSize(containerName, 0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void testClearWithOptions() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.add5NestedBlobsToContainer(containerName);
            ListContainerOptions options = new ListContainerOptions();
            options.prefix("path/1/");
            options.recursive();
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, options);
            this.assertConsistencyAwareContainerSize(containerName, 0);
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.add5NestedBlobsToContainer(containerName);
            options = new ListContainerOptions();
            options.prefix("path/1/2/3");
            options.recursive();
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, options);
            this.assertConsistencyAwareBlobExists(containerName, "path/1/a");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/b");
            this.assertConsistencyAwareBlobDoesntExist(containerName, "path/1/2/3");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.add5NestedBlobsToContainer(containerName);
            options = new ListContainerOptions();
            options.prefix("path/1/2/3/4/");
            options.recursive();
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, options);
            this.assertConsistencyAwareBlobExists(containerName, "path/1/a");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/b");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/3/5/e");
            this.assertConsistencyAwareBlobDoesntExist(containerName, "path/1/2/3/4");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.add5NestedBlobsToContainer(containerName);
            options = new ListContainerOptions();
            options.prefix("path/1/2/3");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, options);
            this.assertConsistencyAwareBlobExists(containerName, "path/1/a");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/b");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/3/c");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/3/5/e");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.add5NestedBlobsToContainer(containerName);
            options = new ListContainerOptions();
            options.prefix("path/1/2/3/");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, options);
            this.assertConsistencyAwareBlobExists(containerName, "path/1/a");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/b");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/3/4/d");
            this.assertConsistencyAwareBlobDoesntExist(containerName, "path/1/2/3/c");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName);
            this.add5NestedBlobsToContainer(containerName);
            options = new ListContainerOptions();
            options.prefix("path/1/2/3/c");
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, options);
            this.assertConsistencyAwareBlobExists(containerName, "path/1/a");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/b");
            this.assertConsistencyAwareBlobExists(containerName, "path/1/2/3/4/d");
            this.assertConsistencyAwareBlobDoesntExist(containerName, "path/1/2/3/c");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerMarker() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addAlphabetUnderRoot(containerName);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1));
            assert (container.getNextMarker() != null);
            Assert.assertEquals((int)container.size(), (int)1);
            String marker = container.getNextMarker();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.afterMarker((String)marker));
            Assert.assertEquals((String)container.getNextMarker(), null);
            assert (container.size() == 25) : String.format("size should have been 25, but was %d: %s", container.size(), container);
            assert (container.getNextMarker() == null);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListRootUsesDelimiter() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String prefix = "rootdelimiter";
            this.addTenObjectsUnderPrefix(containerName, prefix);
            this.add15UnderRoot(containerName);
            this.awaitConsistency();
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            Assert.assertEquals((int)container.size(), (int)16);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testDirectory() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String directory = "directory";
            assert (!((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory));
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory);
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory));
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 0) : container;
            this.addTenObjectsUnderPrefix(containerName, directory);
            this.awaitConsistency();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            Assertions.assertThat((Collection)container).hasSize(2);
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 10) : container;
            assert (!((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory + "/" + directory));
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory + "/" + directory);
            this.awaitConsistency();
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory + "/" + directory));
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            this.awaitConsistency();
            assert (((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory));
            Assertions.assertThat((boolean)((BlobStoreContext)this.view).getBlobStore().directoryExists(containerName, directory + "/" + directory)).isFalse();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            Assertions.assertThat((Collection)container).hasSize(0);
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory + "/" + directory);
            this.awaitConsistency();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory).recursive());
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            ((BlobStoreContext)this.view).getBlobStore().clearContainer(containerName, ListContainerOptions.Builder.inDirectory((String)directory).recursive());
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.inDirectory((String)directory));
            assert (container.getNextMarker() == null);
            assert (container.size() == 0) : container;
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 1) : container;
            ((BlobStoreContext)this.view).getBlobStore().deleteDirectory(containerName, directory);
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            assert (container.getNextMarker() == null);
            assert (container.size() == 0) : container;
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerPrefix() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String prefix = "containerprefix";
            this.addTenObjectsUnderPrefix(containerName, prefix);
            this.add15UnderRoot(containerName);
            this.awaitConsistency();
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, new ListContainerOptions().prefix(prefix + "/").delimiter("/"));
            assert (container.getNextMarker() == null);
            Assert.assertEquals((int)container.size(), (int)10);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerMaxResults() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addAlphabetUnderRoot(containerName);
            ListContainerOptions options = ListContainerOptions.Builder.maxResults((int)10);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)container).hasSize(10);
            Assertions.assertThat((String)container.getNextMarker()).isNotNull();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options.afterMarker(container.getNextMarker()));
            Assertions.assertThat((Collection)container).hasSize(10);
            Assertions.assertThat((String)container.getNextMarker()).isNotNull();
            container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options.afterMarker(container.getNextMarker()));
            Assertions.assertThat((Collection)container).hasSize(6);
            Assertions.assertThat((String)container.getNextMarker()).isNull();
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ignoreOnWindows", groups={"integration", "live"})
    public void testDelimiter() throws Exception {
        String containerName = this.getContainerName();
        try {
            for (String blobName : new String[]{"asdf", "boo" + File.separator + "bar", "boo" + File.separator + "baz" + File.separator + "xyzzy", "cquux" + File.separator + "thud", "cquux" + File.separator + "bla"}) {
                Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(blobName).payload(TEST_STRING).build();
                this.addBlobToContainer(containerName, blob);
            }
            PageSet pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            Assertions.assertThat((Collection)pageSet).hasSize(3);
            Assertions.assertThat((String)pageSet.getNextMarker()).isNull();
            ListContainerOptions options = new ListContainerOptions().maxResults(1);
            pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)pageSet).hasSize(1);
            Assertions.assertThat((String)((StorageMetadata)pageSet.iterator().next()).getName()).isEqualTo("asdf");
            Assertions.assertThat((String)pageSet.getNextMarker()).isNotNull();
            options.afterMarker(pageSet.getNextMarker());
            pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)pageSet).hasSize(1);
            Assertions.assertThat((String)((StorageMetadata)pageSet.iterator().next()).getName()).isEqualTo("boo/");
            Assertions.assertThat((String)pageSet.getNextMarker()).isNotNull();
            options.afterMarker(pageSet.getNextMarker());
            pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)pageSet).hasSize(1);
            Assertions.assertThat((String)((StorageMetadata)pageSet.iterator().next()).getName()).isEqualTo("cquux/");
            Assertions.assertThat((String)pageSet.getNextMarker()).isNull();
            options = new ListContainerOptions().inDirectory("boo").maxResults(1);
            pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)pageSet).hasSize(1);
            Assertions.assertThat((String)((StorageMetadata)pageSet.iterator().next()).getName()).isEqualTo("boo/bar");
            Assertions.assertThat((String)pageSet.getNextMarker()).isNotNull();
            options.afterMarker(pageSet.getNextMarker());
            pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)pageSet).hasSize(1);
            Assertions.assertThat((String)((StorageMetadata)pageSet.iterator().next()).getName()).isEqualTo("boo/baz/");
            Assertions.assertThat((String)pageSet.getNextMarker()).isNull();
            options = new ListContainerOptions().inDirectory("boo").maxResults(2);
            pageSet = ((BlobStoreContext)this.view).getBlobStore().list(containerName, options);
            Assertions.assertThat((Collection)pageSet).hasSize(2);
            Iterator it = pageSet.iterator();
            Assertions.assertThat((String)((StorageMetadata)it.next()).getName()).isEqualTo("boo/bar");
            Assertions.assertThat((String)((StorageMetadata)it.next()).getName()).isEqualTo("boo/baz/");
            Assertions.assertThat((String)pageSet.getNextMarker()).isNull();
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void containerExists() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            assert (((BlobStoreContext)this.view).getBlobStore().containerExists(containerName));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerWithContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, "test");
            ((BlobStoreContext)this.view).getBlobStore().deleteContainer(containerName);
            this.awaitConsistency();
            this.assertNotExists(containerName);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerWithoutContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().deleteContainer(containerName);
            this.awaitConsistency();
            this.assertNotExists(containerName);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyWithContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, "test");
            this.awaitConsistency();
            Assert.assertFalse((boolean)((BlobStoreContext)this.view).getBlobStore().deleteContainerIfEmpty(containerName));
            this.awaitConsistency();
            Assert.assertTrue((boolean)((BlobStoreContext)this.view).getBlobStore().containerExists(containerName));
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyWithoutContents() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            Assert.assertTrue((boolean)((BlobStoreContext)this.view).getBlobStore().deleteContainerIfEmpty(containerName));
            this.awaitConsistency();
            this.assertNotExists(containerName);
            Assert.assertTrue((boolean)((BlobStoreContext)this.view).getBlobStore().deleteContainerIfEmpty(containerName));
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void testListContainer() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            this.add15UnderRoot(containerName);
            this.awaitConsistency();
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            Assert.assertEquals((int)container.size(), (int)15);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainerGetBlobSize() throws Exception {
        String containerName = this.getContainerName();
        try {
            ByteSource byteSource = ByteSource.wrap((byte[])new byte[42]);
            for (int i = 0; i < 2; ++i) {
                ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(i + "").payload(byteSource).contentLength(byteSource.size()).build());
            }
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName);
            for (StorageMetadata metadata : container) {
                Assert.assertEquals((Object)metadata.getSize(), (Object)byteSource.size());
            }
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testSetContainerAccess() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String containerName = this.getContainerName();
        try {
            Assertions.assertThat((Comparable)blobStore.getContainerAccess(containerName)).isEqualTo((Object)ContainerAccess.PRIVATE);
            blobStore.setContainerAccess(containerName, ContainerAccess.PUBLIC_READ);
            Assertions.assertThat((Comparable)blobStore.getContainerAccess(containerName)).isEqualTo((Object)ContainerAccess.PUBLIC_READ);
            String blobName = "blob";
            blobStore.putBlob(containerName, blobStore.blobBuilder(blobName).payload("").build());
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(containerName, blobName).toBuilder().replaceQueryParams((Map)ImmutableMap.of()).build();
            HttpResponse response = ((BlobStoreContext)this.view).utils().http().invoke(request);
            Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
            blobStore.setContainerAccess(containerName, ContainerAccess.PRIVATE);
            Assertions.assertThat((Comparable)blobStore.getContainerAccess(containerName)).isEqualTo((Object)ContainerAccess.PRIVATE);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainerListWithPrefix() throws InterruptedException {
        String containerName = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String prefix = "blob";
        try {
            blobStore.putBlob(containerName, blobStore.blobBuilder(prefix).payload("").build());
            blobStore.putBlob(containerName, blobStore.blobBuilder(prefix + "foo").payload("").build());
            blobStore.putBlob(containerName, blobStore.blobBuilder(prefix + "bar").payload("").build());
            blobStore.putBlob(containerName, blobStore.blobBuilder("foo").payload("").build());
            this.checkEqualNames((Set<String>)ImmutableSet.of((Object)prefix, (Object)(prefix + "foo"), (Object)(prefix + "bar")), (PageSet<? extends StorageMetadata>)blobStore.list(containerName, ListContainerOptions.Builder.prefix((String)prefix)));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainerListWithDetails() throws InterruptedException {
        String containerName = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String prefix = "testContainerListWithDetails/";
        try {
            blobStore.putBlob(containerName, blobStore.blobBuilder(prefix + "foo/bar").payload("").build());
            blobStore.putBlob(containerName, blobStore.blobBuilder(prefix + "car").payload("").build());
            this.checkEqualNames((Set<String>)ImmutableSet.of((Object)(prefix + "foo/"), (Object)(prefix + "car")), (PageSet<? extends StorageMetadata>)blobStore.list(containerName, ListContainerOptions.Builder.prefix((String)prefix).delimiter("/")));
            this.checkEqualNames((Set<String>)ImmutableSet.of((Object)(prefix + "foo/"), (Object)(prefix + "car")), (PageSet<? extends StorageMetadata>)blobStore.list(containerName, ListContainerOptions.Builder.prefix((String)prefix).delimiter("/").withDetails()));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testDelimiterList() throws InterruptedException {
        String containerName = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String payload = "foo";
        try {
            blobStore.putBlob(containerName, blobStore.blobBuilder("test-foo-foo").payload(payload).build());
            blobStore.putBlob(containerName, blobStore.blobBuilder("test-bar-foo").payload(payload).build());
            blobStore.putBlob(containerName, blobStore.blobBuilder("foo").payload(payload).build());
            this.checkEqualNames((Set<String>)ImmutableSet.of((Object)"foo", (Object)"test-"), (PageSet<? extends StorageMetadata>)blobStore.list(containerName, ListContainerOptions.Builder.delimiter((String)"-")));
            this.checkEqualNames((Set<String>)ImmutableSet.of((Object)"test-foo-foo", (Object)"test-bar-foo", (Object)"foo"), (PageSet<? extends StorageMetadata>)blobStore.list(containerName, ListContainerOptions.Builder.delimiter((String)".")));
            blobStore.putBlob(containerName, blobStore.blobBuilder("bar").payload(payload).build());
            blobStore.putBlob(containerName, blobStore.blobBuilder("bazar").payload(payload).build());
            this.checkEqualNames((Set<String>)ImmutableSet.of((Object)"bar", (Object)"baza"), (PageSet<? extends StorageMetadata>)blobStore.list(containerName, ListContainerOptions.Builder.delimiter((String)"a").prefix("ba")));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListMarkerPrefix() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String container = this.getContainerName();
        try {
            blobStore.createContainerInLocation(null, container);
            blobStore.putBlob(container, blobStore.blobBuilder("a/a").payload("").build());
            blobStore.putBlob(container, blobStore.blobBuilder("b/b").payload("").build());
            ListContainerOptions options = new ListContainerOptions().afterMarker("b/").recursive();
            PageSet res = blobStore.list(container, options);
            Assertions.assertThat((Collection)res).hasSize(1);
            Assertions.assertThat((String)((StorageMetadata)res.iterator().next()).getName()).isEqualTo("b/b");
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListEmptyPrefixDelimiter() throws Exception {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        blobStore.createContainerInLocation(null, container);
        try {
            ImmutableList blobs = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
            for (String blob : blobs) {
                blobStore.putBlob(container, blobStore.blobBuilder(blob).payload("").build());
            }
            ListContainerOptions options = ListContainerOptions.Builder.delimiter((String)"").prefix("").afterMarker("");
            PageSet rs = blobStore.list(container, options);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (StorageMetadata sm : rs) {
                builder.add((Object)sm.getName());
            }
            Assertions.assertThat((List)builder.build()).containsExactlyElementsOf((Iterable)blobs);
        }
        finally {
            this.returnContainer(container);
        }
    }

    @DataProvider
    public Object[][] getBlobsToEscape() {
        ImmutableSet testNames = ImmutableSet.of((Object)"%20", (Object)"%20 ", (Object)" %20", (Object)" ", (Object)"%", (Object)"%%", (Object[])new String[0]);
        Object[][] result = new Object[1][1];
        result[0][0] = testNames;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="getBlobsToEscape", groups={"integration", "live"})
    public void testBlobNameEscaping(Set<String> blobNames) throws InterruptedException {
        String containerName = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            for (String name : blobNames) {
                Blob blob = blobStore.blobBuilder(name).payload(ByteSource.wrap((byte[])"test".getBytes())).contentLength(4L).build();
                blobStore.putBlob(containerName, blob);
            }
            this.checkEqualNames(blobNames, (PageSet<? extends StorageMetadata>)blobStore.list(containerName));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    private void checkEqualNames(Set<String> expectedSet, PageSet<? extends StorageMetadata> results) {
        HashSet<String> names = new HashSet<String>();
        for (StorageMetadata sm : results) {
            names.add(sm.getName());
        }
        Assertions.assertThat(names).containsOnlyElementsOf(expectedSet);
    }

    protected void addAlphabetUnderRoot(String containerName) throws InterruptedException {
        for (char letter = 'a'; letter <= 'z'; letter = (char)(letter + '\u0001')) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(letter + "").payload(letter + "content").build());
        }
        this.assertContainerSize(containerName, 26);
    }

    protected void assertContainerSize(final String containerName, final int size) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    Assert.assertEquals((long)((BlobStoreContext)BaseContainerIntegrationTest.this.view).getBlobStore().countBlobs(containerName), (long)size);
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    protected void add15UnderRoot(String containerName) throws InterruptedException {
        for (int i = 0; i < 15; ++i) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(i + "").payload(i + "content").build());
        }
    }

    protected void addTenObjectsUnderPrefix(String containerName, String prefix) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(prefix + "/" + i).payload(i + "content").build());
        }
    }

    @Override
    protected void awaitConsistency() {
        if (((BlobStoreContext)this.view).getConsistencyModel() == ConsistencyModel.EVENTUAL) {
            Uninterruptibles.sleepUninterruptibly((long)AWAIT_CONSISTENCY_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @DataProvider
    public Object[][] ignoreOnWindows() {
        return BaseContainerIntegrationTest.isWindowsOs() ? TestUtils.NO_INVOCATIONS : TestUtils.SINGLE_NO_ARG_INVOCATION;
    }

    private static boolean isWindowsOs() {
        return System.getProperty("os.name", "").toLowerCase().contains("windows");
    }
}

