/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Injector;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.DeleteAllKeysInList;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.util.Closeables2;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="DeleteAllKeysInListTest", singleThreaded=true)
public class DeleteAllKeysInListTest {
    private BlobStore blobstore;
    private DeleteAllKeysInList deleter;
    private BackoffLimitedRetryHandler retryHandler;
    private static final String containerName = "container";
    private static final String directoryName = "directory";
    private static final int maxParallelDeletes = 1024;

    @BeforeMethod
    void setupBlobStore() {
        Injector injector = ContextBuilder.newBuilder((String)"transient").buildInjector();
        this.blobstore = (BlobStore)injector.getInstance(BlobStore.class);
        this.deleter = (DeleteAllKeysInList)injector.getInstance(DeleteAllKeysInList.class);
        this.retryHandler = (BackoffLimitedRetryHandler)injector.getInstance(BackoffLimitedRetryHandler.class);
        this.createDataSet();
    }

    @AfterMethod
    void close() {
        Closeables2.closeQuietly((Closeable)this.blobstore.getContext());
    }

    public void testExecuteWithoutOptionsClearsRecursively() {
        this.deleter.execute(containerName);
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)0L);
    }

    public void testExecuteRecursive() {
        this.deleter.execute(containerName, ListContainerOptions.Builder.recursive());
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)0L);
    }

    public void testExecuteNonRecursive() {
        this.deleter.execute(containerName, (ListContainerOptions)ListContainerOptions.NONE);
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)2222L);
    }

    public void testExecuteInDirectory() {
        this.deleter.execute(containerName, ListContainerOptions.Builder.inDirectory((String)directoryName));
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)1111L);
    }

    public void testContainerNotFound() {
        IMocksControl mockControl = EasyMock.createControl();
        BlobStore blobStore = (BlobStore)mockControl.createMock(BlobStore.class);
        ListeningExecutorService executorService = (ListeningExecutorService)mockControl.createMock(ListeningExecutorService.class);
        DeleteAllKeysInList testDeleter = (DeleteAllKeysInList)EasyMock.createMockBuilder(DeleteAllKeysInList.class).withConstructor(new Object[]{executorService, blobStore, this.retryHandler, 1024}).createMock();
        EasyMock.expect((Object)blobStore.list((String)EasyMock.isA(String.class), (ListContainerOptions)EasyMock.isA(ListContainerOptions.class))).andThrow((Throwable)new ContainerNotFoundException()).once();
        EasyMock.replay((Object[])new Object[]{blobStore});
        testDeleter.execute(containerName, ListContainerOptions.Builder.recursive());
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)3333L);
    }

    public void testDeleteAfterFutureFailure() {
        IMocksControl mockControl = EasyMock.createControl();
        ListeningExecutorService executorService = (ListeningExecutorService)mockControl.createMock(ListeningExecutorService.class);
        DeleteAllKeysInList testDeleter = (DeleteAllKeysInList)EasyMock.createMockBuilder(DeleteAllKeysInList.class).withConstructor(new Object[]{executorService, this.blobstore, this.retryHandler, 1024}).createMock();
        EasyMock.expect((Object)executorService.submit((Callable)EasyMock.isA(Callable.class))).andReturn((Object)Futures.immediateFailedFuture((Throwable)new RuntimeException())).once();
        EasyMock.expectLastCall().andReturn((Object)Futures.immediateFuture(null)).times(3333, Integer.MAX_VALUE);
        EasyMock.replay((Object[])new Object[]{executorService});
        testDeleter.execute(containerName, ListContainerOptions.Builder.recursive());
    }

    public void testExceptionThrownAfterMaxRetries() {
        IMocksControl mockControl = EasyMock.createControl();
        ListeningExecutorService executorService = (ListeningExecutorService)mockControl.createMock(ListeningExecutorService.class);
        DeleteAllKeysInList testDeleter = (DeleteAllKeysInList)EasyMock.createMockBuilder(DeleteAllKeysInList.class).withConstructor(new Object[]{executorService, this.blobstore, this.retryHandler, 1024}).createMock();
        EasyMock.expect((Object)executorService.submit((Callable)EasyMock.isA(Callable.class))).andReturn((Object)Futures.immediateFailedFuture((Throwable)new RuntimeException())).once();
        EasyMock.expectLastCall().andReturn((Object)Futures.immediateFuture(null)).anyTimes();
        EasyMock.replay((Object[])new Object[]{executorService});
        testDeleter.setMaxErrors(1);
        boolean blobRunTimeExceptionThrown = false;
        try {
            testDeleter.execute(containerName, ListContainerOptions.Builder.recursive());
        }
        catch (BlobRuntimeException be) {
            blobRunTimeExceptionThrown = true;
        }
        Assert.assertTrue((boolean)blobRunTimeExceptionThrown, (String)"Expected a BlobRunTimeException");
    }

    public void testFuturesCancelledOnFailure() {
        IMocksControl mockControl = EasyMock.createControl();
        ListeningExecutorService executorService = (ListeningExecutorService)mockControl.createMock(ListeningExecutorService.class);
        DeleteAllKeysInList testDeleter = (DeleteAllKeysInList)EasyMock.createMockBuilder(DeleteAllKeysInList.class).withConstructor(new Object[]{executorService, this.blobstore, this.retryHandler, 1024}).createMock();
        AtomicBoolean deleteFailure = new AtomicBoolean();
        Semaphore semaphore = (Semaphore)EasyMock.createMock(Semaphore.class);
        Set outstandingFutures = Collections.synchronizedSet(new HashSet());
        ListenableFuture blobDelFuture = (ListenableFuture)EasyMock.createMock(ListenableFuture.class);
        try {
            EasyMock.expect((Object)semaphore.tryAcquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS)).andReturn((Object)true).once();
            EasyMock.expect((Object)executorService.submit((Callable)EasyMock.isA(Callable.class))).andReturn((Object)blobDelFuture).once();
            EasyMock.expect((Object)semaphore.tryAcquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS)).andReturn((Object)false).anyTimes();
            blobDelFuture.addListener((Runnable)EasyMock.isA(Runnable.class), (Executor)EasyMock.isA(Executor.class));
            EasyMock.expectLastCall();
            EasyMock.expect((Object)blobDelFuture.cancel(true)).andReturn((Object)true).atLeastOnce();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        EasyMock.replay((Object[])new Object[]{semaphore, executorService, blobDelFuture});
        testDeleter.setMaxErrors(1);
        testDeleter.executeOneIteration(containerName, ListContainerOptions.Builder.recursive(), semaphore, outstandingFutures, deleteFailure, false);
        Assert.assertEquals((int)outstandingFutures.size(), (int)1);
        Assert.assertTrue((boolean)deleteFailure.get());
    }

    private void createDataSet() {
        int i;
        String blobNameFmt = "blob-%d";
        String directoryBlobNameFmt = "%s/blob-%d";
        this.blobstore.createContainerInLocation(null, containerName);
        for (i = 0; i < 1111; ++i) {
            String blobName = String.format(blobNameFmt, i);
            this.blobstore.putBlob(containerName, this.blobstore.blobBuilder(blobName).payload(blobName).build());
        }
        for (i = 0; i < 2222; ++i) {
            String directoryBlobName = String.format(directoryBlobNameFmt, directoryName, i);
            this.blobstore.putBlob(containerName, this.blobstore.blobBuilder(directoryBlobName).payload(directoryBlobName).build());
        }
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)3333L);
    }
}

