/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.net.URI;
import java.util.Map;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseSystemAndUserMetadataFromHeaders
implements Function<HttpResponse, MutableBlobMetadata>,
InvocationContext<ParseSystemAndUserMetadataFromHeaders> {
    private final String metadataPrefix;
    private final DateService dateParser;
    private final Provider<MutableBlobMetadata> metadataFactory;
    private String name;
    private URI endpoint;

    @Inject
    public ParseSystemAndUserMetadataFromHeaders(Provider<MutableBlobMetadata> metadataFactory, DateService dateParser, @Named(value="jclouds.blobstore.metaprefix") String metadataPrefix) {
        this.metadataFactory = (Provider)Preconditions.checkNotNull(metadataFactory, (Object)"metadataFactory");
        this.dateParser = (DateService)Preconditions.checkNotNull((Object)dateParser, (Object)"dateParser");
        this.metadataPrefix = ((String)Preconditions.checkNotNull((Object)metadataPrefix, (Object)"metadataPrefix")).toLowerCase();
    }

    public MutableBlobMetadata apply(HttpResponse from) {
        Preconditions.checkNotNull((Object)from, (Object)"request");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"name must be initialized by now");
        MutableBlobMetadata to = (MutableBlobMetadata)this.metadataFactory.get();
        to.setName(this.name);
        to.setUri(this.endpoint);
        if (from.getPayload() != null) {
            HttpUtils.copy((ContentMetadata)from.getPayload().getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        }
        this.addETagTo(from, to);
        this.parseLastModifiedOrThrowException(from, to);
        this.addUserMetadataTo(from, to);
        return to;
    }

    @VisibleForTesting
    void addUserMetadataTo(HttpResponse from, MutableBlobMetadata metadata) {
        for (Map.Entry header : from.getHeaders().entries()) {
            if (header.getKey() == null || !((String)header.getKey()).toLowerCase().startsWith(this.metadataPrefix)) continue;
            metadata.getUserMetadata().put(((String)header.getKey()).substring(this.metadataPrefix.length()).toLowerCase(), (String)header.getValue());
        }
    }

    @VisibleForTesting
    void parseLastModifiedOrThrowException(HttpResponse from, MutableBlobMetadata metadata) throws HttpException {
        String lastModified = from.getFirstHeaderOrNull("Last-Modified");
        if (lastModified == null && (lastModified = from.getFirstHeaderOrNull("Last-modified")) == null) {
            throw new HttpException("Last-Modified header not present in response: " + from);
        }
        if (lastModified.startsWith("20")) {
            metadata.setLastModified(this.dateParser.iso8601DateParse(lastModified.replace("+0000", "Z")));
        } else {
            metadata.setLastModified(this.dateParser.rfc822DateParse(lastModified));
        }
        if (metadata.getLastModified() == null) {
            throw new HttpException("could not parse: Last-Modified: " + lastModified);
        }
    }

    protected void addETagTo(HttpResponse from, MutableBlobMetadata metadata) {
        String eTag = from.getFirstHeaderOrNull("ETag");
        if (metadata.getETag() == null && eTag != null) {
            metadata.setETag(eTag);
        }
    }

    public ParseSystemAndUserMetadataFromHeaders setContext(HttpRequest request) {
        this.endpoint = request.getEndpoint();
        Preconditions.checkArgument((boolean)(request instanceof GeneratedHttpRequest), (Object)"note this handler requires a GeneratedHttpRequest");
        return this.setName(BlobStoreUtils.getNameFor((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)));
    }

    public ParseSystemAndUserMetadataFromHeaders setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        return this;
    }
}

