/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class PutBlobsStrategyImpl
implements PutBlobsStrategy {
    private final BlobStore blobstore;
    private final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    PutBlobsStrategyImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BlobStore blobstore) {
        this.userExecutor = userExecutor;
        this.blobstore = blobstore;
    }

    @Override
    public void execute(final String containerName, Iterable<? extends Blob> blobs) {
        Map exceptions;
        LinkedHashMap responses = Maps.newLinkedHashMap();
        for (final Blob blob : blobs) {
            responses.put(blob, this.userExecutor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return PutBlobsStrategyImpl.this.blobstore.putBlob(containerName, blob);
                }
            }));
        }
        try {
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)String.format("putting into containerName: %s", containerName));
        }
        catch (TimeoutException timeoutException) {
            throw Throwables.propagate((Throwable)timeoutException);
        }
        if (!exceptions.isEmpty()) {
            throw new BlobRuntimeException(String.format("error putting into container %s: %s", containerName, exceptions));
        }
    }
}

