/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.events.StatementOnNodeCompletion;
import org.jclouds.compute.events.StatementOnNodeFailure;
import org.jclouds.compute.events.StatementOnNodeSubmission;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;

public class RunScriptOnNodeUsingSsh
implements RunScriptOnNode {
    public static final String MARKER = "RUN_SCRIPT_AS_ROOT_SSH";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Function<NodeMetadata, SshClient> sshFactory;
    protected final EventBus eventBus;
    protected final NodeMetadata node;
    protected final Statement statement;
    protected final boolean runAsRoot;
    protected SshClient ssh;

    @AssistedInject
    public RunScriptOnNodeUsingSsh(Function<NodeMetadata, SshClient> sshFactory, EventBus eventBus, @Assisted NodeMetadata node, @Assisted Statement statement, @Assisted RunScriptOptions options) {
        this.sshFactory = (Function)Preconditions.checkNotNull(sshFactory, (Object)"sshFactory");
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus, (Object)"eventBus");
        this.node = (NodeMetadata)Preconditions.checkNotNull((Object)node, (Object)"node");
        this.statement = (Statement)Preconditions.checkNotNull((Object)statement, (Object)"statement");
        this.runAsRoot = options.shouldRunAsRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResponse call() {
        Preconditions.checkState((this.ssh != null ? 1 : 0) != 0, (Object)"please call init() before invoking call");
        try {
            ExecResponse returnVal;
            this.ssh.connect();
            this.eventBus.post((Object)new StatementOnNodeSubmission(this.statement, this.node));
            String command = this.runAsRoot ? this.execAsRoot(this.statement.render(OsFamily.UNIX)) : this.execScriptAsDefaultUser(this.statement.render(OsFamily.UNIX));
            try {
                returnVal = this.runCommand(command);
            }
            catch (Throwable e) {
                this.eventBus.post((Object)new StatementOnNodeFailure(this.statement, this.node, e));
                throw Throwables.propagate((Throwable)e);
            }
            this.eventBus.post((Object)new StatementOnNodeCompletion(this.statement, this.node, returnVal));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< %s[%s]", new Object[]{this.statement, returnVal});
            } else {
                this.logger.debug("<< %s(%d)", new Object[]{this.statement, returnVal.getExitStatus()});
            }
            ExecResponse execResponse = returnVal;
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    @Override
    public RunScriptOnNode init() {
        this.ssh = (SshClient)this.sshFactory.apply((Object)this.node);
        return this;
    }

    protected ExecResponse runCommand(String command) {
        this.logger.debug(">> running [%s] as %s@%s", new Object[]{command.replace(this.node.getCredentials().getOptionalPassword().isPresent() ? (String)this.node.getCredentials().getOptionalPassword().get() : "XXXXX", "XXXXX"), this.ssh.getUsername(), this.ssh.getHostAddress()});
        ExecResponse returnVal = this.ssh.exec(command);
        return returnVal;
    }

    @VisibleForTesting
    public String execAsRoot(String command) {
        if (!this.node.getCredentials().identity.equals("root")) {
            command = this.node.getCredentials().shouldAuthenticateSudo() ? String.format("sudo -S sh <<'%s'\n%s\n%s%s\n", MARKER, this.node.getCredentials().getOptionalPassword().get(), command, MARKER) : String.format("sudo sh <<'%s'\n%s%s\n", MARKER, command, MARKER);
        }
        return command;
    }

    protected String execScriptAsDefaultUser(String command) {
        return command;
    }

    @Override
    public NodeMetadata getNode() {
        return this.node;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node", (Object)this.node).add("name", (Object)this.statement).add("runAsRoot", this.runAsRoot).toString();
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }
}

