/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;

public class GitRepoAndRef {
    protected final URI repository;
    protected final Optional<String> branch;
    protected final Optional<String> tag;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromGitRepoAndRef(this);
    }

    protected GitRepoAndRef(URI repository, Optional<String> branch, Optional<String> tag) {
        this.repository = (URI)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.branch = (Optional)Preconditions.checkNotNull(branch, (Object)"branch");
        this.tag = (Optional)Preconditions.checkNotNull(tag, (Object)"tag");
    }

    public URI getRepository() {
        return this.repository;
    }

    public Optional<String> getBranch() {
        return this.branch;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.repository, this.branch, this.tag});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitRepoAndRef other = (GitRepoAndRef)GitRepoAndRef.class.cast(obj);
        return Objects.equal((Object)this.repository, (Object)other.repository) && Objects.equal(this.branch, other.branch) && Objects.equal(this.tag, other.tag);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("repository", (Object)this.repository).add("branch", this.branch.orNull()).add("tag", this.tag.orNull()).toString();
    }

    public static class Builder {
        protected URI repository;
        protected Optional<String> branch = Optional.absent();
        protected Optional<String> tag = Optional.absent();

        public Builder repository(URI repository) {
            this.repository = repository;
            return this;
        }

        public Builder repository(String repository) {
            return this.repository(URI.create(repository));
        }

        public Builder branch(String branch) {
            this.branch = Optional.fromNullable((Object)branch);
            return this;
        }

        public Builder tag(String tag) {
            this.tag = Optional.fromNullable((Object)tag);
            return this;
        }

        public GitRepoAndRef build() {
            return new GitRepoAndRef(this.repository, this.branch, this.tag);
        }

        public Builder fromGitRepoAndRef(GitRepoAndRef in) {
            return this.repository(in.getRepository()).branch((String)in.getBranch().orNull()).tag((String)in.getTag().orNull());
        }
    }
}

