/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.cache;

import com.google.common.reflect.TypeToken;
import java.util.Hashtable;
import org.jclouds.chef.ChefApi;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheManager;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.cache.utils.CacheUtils;
import org.jclouds.rest.ApiContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker chefServiceTracker;
    private ServiceTracker chefCacheableTracker;
    private ServiceRegistration cacheProviderRegistration;
    private final CacheManager<ApiContext<ChefApi>> chefCacheManager = new CacheManager();

    public void start(BundleContext context) throws Exception {
        BasicCacheProvider cacheProvider = new BasicCacheProvider();
        this.cacheProviderRegistration = context.registerService(CacheProvider.class.getName(), (Object)cacheProvider, new Hashtable());
        this.chefServiceTracker = CacheUtils.createServiceCacheTracker(context, new TypeToken<ApiContext<ChefApi>>(){
            private static final long serialVersionUID = 1L;
        }, this.chefCacheManager);
        this.chefCacheableTracker = CacheUtils.createCacheableTracker(context, "jclouds.chefservice", this.chefCacheManager);
        this.chefServiceTracker.open();
        this.chefCacheableTracker.open();
        this.chefCacheManager.init();
    }

    public void stop(BundleContext context) throws Exception {
        this.chefCacheManager.destroy();
        if (this.cacheProviderRegistration != null) {
            this.cacheProviderRegistration.unregister();
        }
        if (this.chefServiceTracker != null) {
            this.chefServiceTracker.close();
        }
        if (this.chefCacheableTracker != null) {
            this.chefCacheableTracker.close();
        }
    }
}

