/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.services;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefService;
import org.jclouds.chef.domain.BootstrapConfig;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.util.RunListBuilder;
import org.jclouds.karaf.recipe.RecipeProvider;
import org.jclouds.rest.ApiContext;
import org.jclouds.scriptbuilder.domain.Statement;

public class ChefRecipeProvider
implements RecipeProvider {
    final ChefService chefService;
    final String id;

    public ChefRecipeProvider(ApiContext<ChefApi> ctx) {
        this.chefService = ((ChefApi)ctx.getApi()).chefService();
        this.id = ctx.getName();
    }

    public String getId() {
        return this.id;
    }

    public Statement createStatement(String recipe, String group) {
        List runlist = new RunListBuilder().addRecipes(new String[]{recipe}).build();
        BootstrapConfig bootstrapConfig = BootstrapConfig.builder().runList((Iterable)runlist).build();
        this.chefService.updateBootstrapConfigForGroup(group, bootstrapConfig);
        return this.chefService.createBootstrapScriptForGroup(group);
    }

    public Set<String> listProvidedRecipes() {
        HashSet recipes = Sets.newHashSet();
        for (CookbookVersion cookbookVersion : this.chefService.listCookbookVersions()) {
            for (String recipe : cookbookVersion.getMetadata().getProviding().keySet()) {
                recipes.add(this.id + "/" + recipe);
            }
        }
        return recipes;
    }
}

