/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.services;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiPredicates;
import org.jclouds.chef.ChefApi;
import org.jclouds.karaf.chef.core.ChefHelper;
import org.jclouds.karaf.services.InvalidConfigurationException;
import org.jclouds.karaf.services.ServiceFactorySupport;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.ApiContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChefServiceFactory
extends ServiceFactorySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChefServiceFactory.class);
    private final BundleContext bundleContext;

    public ChefServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "Chef Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration;
        block10: {
            ApiMetadata apiMetadata;
            block11: {
                ServiceRegistration oldRegistration2;
                newRegistration = null;
                if (properties == null) break block10;
                Properties props = new Properties();
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = properties.get(key);
                    props.put(key, val);
                }
                String api = (String)properties.get("api");
                Object providerMetadata = null;
                apiMetadata = null;
                if (!Strings.isNullOrEmpty((String)api) && this.installedApis.containsKey(api)) {
                    apiMetadata = (ApiMetadata)this.installedApis.get(api);
                    ChefServiceFactory.validate(apiMetadata, properties);
                    break block11;
                }
                if (!Strings.isNullOrEmpty((String)api)) {
                    this.apiPids.put(api, pid);
                }
                this.pendingPids.put(pid, properties);
                LOGGER.warn("Api {} is not currently installed. Service will resume once the the api is installed.", (Object)api);
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration2 == null) return;
                oldRegistration2.unregister();
                return;
            }
            try {
                String id = (String)properties.get("name");
                String clientName = (String)properties.get("client.name");
                String clientKeyFile = (String)properties.get("client.keyFile");
                String clientCredential = (String)properties.get("client.credential");
                String validatorName = (String)properties.get("validator.name");
                String validatorKeyFile = (String)properties.get("validator.keyFile");
                String validatorCredential = (String)properties.get("validator.credential");
                String endpoint = (String)properties.get("endpoint");
                ApiContext<ChefApi> service = ChefHelper.createChefService(apiMetadata, id, clientName, clientCredential, clientKeyFile, validatorName, validatorCredential, validatorKeyFile, endpoint);
                newRegistration = this.bundleContext.registerService(ApiContext.class.getName(), service, properties);
                if (!this.pendingPids.containsKey(pid)) break block10;
                this.activePids.put(pid, this.pendingPids.remove(pid));
            }
            catch (InvalidConfigurationException ex) {
                ServiceRegistration oldRegistration3;
                LOGGER.warn("Invalid configuration: {}", (Object)ex.getMessage());
                ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration3 == null) return;
                oldRegistration3.unregister();
                return;
            }
            catch (Exception ex2) {
                ServiceRegistration oldRegistration4;
                LOGGER.error("Error creating compute service.", (Throwable)ex2);
                ServiceRegistration serviceRegistration = oldRegistration4 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                {
                    catch (Throwable throwable) {
                        ServiceRegistration oldRegistration5;
                        ServiceRegistration serviceRegistration2 = oldRegistration5 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                        if (oldRegistration5 == null) throw throwable;
                        oldRegistration5.unregister();
                        throw throwable;
                    }
                }
                if (oldRegistration4 == null) return;
                oldRegistration4.unregister();
                return;
            }
        }
        ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        if (oldRegistration == null) return;
        oldRegistration.unregister();
        return;
    }

    public static void validate(ApiMetadata apiMetadata, Dictionary properties) throws InvalidConfigurationException {
        if (Strings.isNullOrEmpty((String)((String)properties.get("client.name")))) {
            throw new InvalidConfigurationException("No client name specified.");
        }
        if (Strings.isNullOrEmpty((String)((String)properties.get("validator.name")))) {
            throw new InvalidConfigurationException("No validator name specified.");
        }
        if (Strings.isNullOrEmpty((String)((String)properties.get("endpoint"))) && !apiMetadata.getDefaultEndpoint().isPresent()) {
            throw new InvalidConfigurationException("No endpoint specified specified.");
        }
    }

    public boolean apply(ProviderMetadata provider) {
        return false;
    }

    public boolean apply(ApiMetadata api) {
        return ApiPredicates.contextAssignableFrom(ChefHelper.CHEF_TOKEN).apply((Object)api);
    }
}

