/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandBase;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="jclouds", name="blobstore-service-destroy", description="Destroys a BlobStore service.", detailedDescription="classpath:blobstore-service-destroy.txt")
public class BlobStoreServiceDestroyCommand
extends BlobStoreCommandBase {
    @Argument(index=0, required=true, multiValued=false, description="The service id. Used to distinct between multiple service of the same provider/api. Only ")
    protected String id;

    protected Object doExecute() throws Exception {
        if (this.id == null) {
            System.err.println("You need to either specify the service id.");
            return null;
        }
        Configuration configuration = this.findOrCreateFactoryConfiguration(this.configAdmin, "org.jclouds.blobstore", this.id, null, null);
        if (configuration != null) {
            configuration.delete();
        } else {
            System.out.println("No service found for provider / api");
        }
        return null;
    }

    @Override
    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    @Override
    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

