/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-write", description="Writes data to the blobstore")
public class BlobWriteCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Argument(index=2, name="payload", description="Payload, interpreted as a file name by default", required=true, multiValued=false)
    String payload;
    @Option(name="-s", aliases={"--string-payload"}, description="Use string payload instead of a file", required=false, multiValued=false)
    boolean stringPayload;
    @Option(name="-u", aliases={"--url-payload"}, description="Use payload from a URL instead of a file", required=false, multiValued=false)
    boolean urlPayload;
    @Option(name="-m", aliases={"--multipart-upload"}, description="Use multi-part upload", required=false, multiValued=false)
    boolean multipartUpload;
    @Option(name="-S", aliases={"--signed-request"}, description="Use a signed request", required=false, multiValued=false)
    boolean signedRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        BlobBuilder builder = blobStore.blobBuilder(this.blobName);
        if (this.stringPayload) {
            builder = builder.payload(this.payload.getBytes());
        } else if (this.urlPayload) {
            InputStream input = new URL(this.payload).openStream();
            try {
                builder = builder.payload(ByteStreams.toByteArray((InputStream)input));
            }
            finally {
                input.close();
            }
        } else {
            ByteSource byteSource = Files.asByteSource((File)new File(this.payload));
            BlobBuilder.PayloadBlobBuilder payloadBuilder = builder.payload(byteSource).contentLength(byteSource.size());
            if (!this.multipartUpload) {
                payloadBuilder = payloadBuilder.contentMD5(byteSource.hash(Hashing.md5()).asBytes());
            }
            builder = payloadBuilder;
        }
        PutOptions.ImmutablePutOptions options = this.multipartUpload ? new PutOptions().multipart(true) : PutOptions.NONE;
        this.write(blobStore, this.containerName, this.blobName, builder.build(), (PutOptions)options, this.signedRequest);
        this.cacheProvider.getProviderCacheForType("container").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.containerName);
        this.cacheProvider.getProviderCacheForType("blob").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.blobName);
        return null;
    }
}

