/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-container-list", description="Lists all container names")
public class ContainerListCommand
extends BlobStoreCommandWithOptions {
    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        ArrayList containerNames = Lists.newArrayList();
        for (StorageMetadata containerMetadata : blobStore.list()) {
            containerNames.add(containerMetadata.getName());
        }
        Collections.sort(containerNames);
        for (String containerName : containerNames) {
            System.out.println(containerName);
        }
        return null;
    }
}

