/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineManager;
import org.jclouds.karaf.commands.table.ShellTable;
import org.jclouds.karaf.commands.table.ShellTableFactory;
import org.jclouds.karaf.commands.table.internal.ScriptEngineShellTable;

public class BasicShellTableFactory
implements ShellTableFactory {
    private ScriptEngineManager scriptEngineManager;
    private final Map properties = new HashMap();

    @Override
    public ShellTable build(String type) {
        String delimiter = this.properties.containsKey(type + "." + "delimiter") ? String.valueOf(this.properties.get(type + "." + "delimiter")) : ";";
        String engine = this.properties.containsKey(type + "." + "engine") ? String.valueOf(this.properties.get(type + "." + "engine")) : "groovy";
        String headersValue = String.valueOf(this.properties.get(type + "." + "headers"));
        String expressionsValue = String.valueOf(this.properties.get(type + "." + "expressions"));
        String alignValue = String.valueOf(this.properties.get(type + "." + "alignments"));
        String sortByValue = String.valueOf(this.properties.get(type + "." + "sortby"));
        Boolean ascendingValue = Boolean.parseBoolean(String.valueOf(this.properties.get(type + "." + "ascending")));
        List<String> headers = Arrays.asList(headersValue.split(delimiter));
        List<String> expressions = Arrays.asList(expressionsValue.split(delimiter));
        List<String> alignments = Arrays.asList(alignValue.split(delimiter));
        ScriptEngineShellTable shellTable = new ScriptEngineShellTable(this.scriptEngineManager, engine);
        shellTable.setType(type);
        shellTable.setHeaders(headers);
        shellTable.setDisplayExpression(expressions);
        shellTable.setAlignments(alignments);
        shellTable.setSortBy(sortByValue);
        shellTable.setAscending(ascendingValue);
        return shellTable;
    }

    public Map getProperties() {
        return this.properties;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }
}

